<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for server StructType
 * @subpackage Structs
 */
class Server extends AbstractStructBase
{
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The ldapPortNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPortNumber;
    /**
     * The sslEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sslEnabled;
    /**
     * The ldapPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPort;
    /**
     * Constructor method for server
     * @uses Server::setHostName()
     * @uses Server::setLdapPortNumber()
     * @uses Server::setSslEnabled()
     * @uses Server::setLdapPort()
     * @param string $hostName
     * @param string $ldapPortNumber
     * @param string $sslEnabled
     * @param string $ldapPort
     */
    public function __construct($hostName = null, $ldapPortNumber = null, $sslEnabled = null, $ldapPort = null)
    {
        $this
            ->setHostName($hostName)
            ->setLdapPortNumber($ldapPortNumber)
            ->setSslEnabled($sslEnabled)
            ->setLdapPort($ldapPort);
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \StructType\Server
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hostName, true), gettype($hostName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($hostName) && mb_strlen($hostName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get ldapPortNumber value
     * @return string|null
     */
    public function getLdapPortNumber()
    {
        return $this->ldapPortNumber;
    }
    /**
     * Set ldapPortNumber value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapPortNumber
     * @return \StructType\Server
     */
    public function setLdapPortNumber($ldapPortNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ldapPortNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ldapPortNumber) ? implode(', ', $ldapPortNumber) : var_export($ldapPortNumber, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ldapPortNumber = $ldapPortNumber;
        return $this;
    }
    /**
     * Get sslEnabled value
     * @return string|null
     */
    public function getSslEnabled()
    {
        return $this->sslEnabled;
    }
    /**
     * Set sslEnabled value
     * @param string $sslEnabled
     * @return \StructType\Server
     */
    public function setSslEnabled($sslEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($sslEnabled) && !is_string($sslEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sslEnabled, true), gettype($sslEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($sslEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sslEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($sslEnabled, true)), __LINE__);
        }
        $this->sslEnabled = $sslEnabled;
        return $this;
    }
    /**
     * Get ldapPort value
     * @return string|null
     */
    public function getLdapPort()
    {
        return $this->ldapPort;
    }
    /**
     * Set ldapPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapPort
     * @return \StructType\Server
     */
    public function setLdapPort($ldapPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ldapPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($ldapPort) ? implode(', ', $ldapPort) : var_export($ldapPort, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ldapPort = $ldapPort;
        return $this;
    }
}
