<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVmPilot StructType
 * @subpackage Structs
 */
class RVmPilot extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dirn;
    /**
     * The cssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cssName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVmPilot
     * @uses RVmPilot::setDirn()
     * @uses RVmPilot::setCssName()
     * @uses RVmPilot::setUuid()
     * @param string $dirn
     * @param \StructType\XFkType $cssName
     * @param string $uuid
     */
    public function __construct($dirn = null, \StructType\XFkType $cssName = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setCssName($cssName)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \StructType\RVmPilot
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dirn, true), gettype($dirn)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($dirn) && mb_strlen($dirn) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get cssName value
     * @return \StructType\XFkType|null
     */
    public function getCssName()
    {
        return $this->cssName;
    }
    /**
     * Set cssName value
     * @param \StructType\XFkType $cssName
     * @return \StructType\RVmPilot
     */
    public function setCssName(\StructType\XFkType $cssName = null)
    {
        $this->cssName = $cssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RVmPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
