<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUserGroupRoles StructType
 * @subpackage Structs
 */
class RUserGroupRoles extends AbstractStructBase
{
    /**
     * The roleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $roleName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUserGroupRoles
     * @uses RUserGroupRoles::setRoleName()
     * @uses RUserGroupRoles::setUuid()
     * @param \StructType\XFkType $roleName
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $roleName = null, $uuid = null)
    {
        $this
            ->setRoleName($roleName)
            ->setUuid($uuid);
    }
    /**
     * Get roleName value
     * @return \StructType\XFkType|null
     */
    public function getRoleName()
    {
        return $this->roleName;
    }
    /**
     * Set roleName value
     * @param \StructType\XFkType $roleName
     * @return \StructType\RUserGroupRoles
     */
    public function setRoleName(\StructType\XFkType $roleName = null)
    {
        $this->roleName = $roleName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RUserGroupRoles
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
