<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTransformationProfile StructType
 * @subpackage Structs
 */
class RTransformationProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $nationalCssName;
    /**
     * The internationalCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $internationalCssName;
    /**
     * The unknownCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $unknownCssName;
    /**
     * The subscriberCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $subscriberCssName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTransformationProfile
     * @uses RTransformationProfile::setName()
     * @uses RTransformationProfile::setDescription()
     * @uses RTransformationProfile::setNationalStripDigits()
     * @uses RTransformationProfile::setInternationalStripDigits()
     * @uses RTransformationProfile::setUnknownStripDigits()
     * @uses RTransformationProfile::setSubscriberStripDigits()
     * @uses RTransformationProfile::setNationalPrefix()
     * @uses RTransformationProfile::setInternationalPrefix()
     * @uses RTransformationProfile::setUnknownPrefix()
     * @uses RTransformationProfile::setSubscriberPrefix()
     * @uses RTransformationProfile::setNationalCssName()
     * @uses RTransformationProfile::setInternationalCssName()
     * @uses RTransformationProfile::setUnknownCssName()
     * @uses RTransformationProfile::setSubscriberCssName()
     * @uses RTransformationProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \StructType\XFkType $nationalCssName
     * @param \StructType\XFkType $internationalCssName
     * @param \StructType\XFkType $unknownCssName
     * @param \StructType\XFkType $subscriberCssName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \StructType\XFkType $nationalCssName = null, \StructType\XFkType $internationalCssName = null, \StructType\XFkType $unknownCssName = null, \StructType\XFkType $subscriberCssName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalCssName($nationalCssName)
            ->setInternationalCssName($internationalCssName)
            ->setUnknownCssName($unknownCssName)
            ->setSubscriberCssName($subscriberCssName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RTransformationProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RTransformationProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return $this->nationalStripDigits;
    }
    /**
     * Set nationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return \StructType\RTransformationProfile
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($nationalStripDigits) ? implode(', ', $nationalStripDigits) : var_export($nationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->nationalStripDigits = $nationalStripDigits;
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return $this->internationalStripDigits;
    }
    /**
     * Set internationalStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return \StructType\RTransformationProfile
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($internationalStripDigits) ? implode(', ', $internationalStripDigits) : var_export($internationalStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->internationalStripDigits = $internationalStripDigits;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return $this->unknownStripDigits;
    }
    /**
     * Set unknownStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return \StructType\RTransformationProfile
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($unknownStripDigits) ? implode(', ', $unknownStripDigits) : var_export($unknownStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->unknownStripDigits = $unknownStripDigits;
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return $this->subscriberStripDigits;
    }
    /**
     * Set subscriberStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return \StructType\RTransformationProfile
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($subscriberStripDigits) ? implode(', ', $subscriberStripDigits) : var_export($subscriberStripDigits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->subscriberStripDigits = $subscriberStripDigits;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \StructType\RTransformationProfile
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalPrefix, true), gettype($nationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($nationalPrefix) && mb_strlen($nationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \StructType\RTransformationProfile
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internationalPrefix, true), gettype($internationalPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($internationalPrefix) && mb_strlen($internationalPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \StructType\RTransformationProfile
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unknownPrefix, true), gettype($unknownPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($unknownPrefix) && mb_strlen($unknownPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \StructType\RTransformationProfile
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriberPrefix, true), gettype($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($subscriberPrefix) && mb_strlen($subscriberPrefix) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalCssName value
     * @return \StructType\XFkType|null
     */
    public function getNationalCssName()
    {
        return $this->nationalCssName;
    }
    /**
     * Set nationalCssName value
     * @param \StructType\XFkType $nationalCssName
     * @return \StructType\RTransformationProfile
     */
    public function setNationalCssName(\StructType\XFkType $nationalCssName = null)
    {
        $this->nationalCssName = $nationalCssName;
        return $this;
    }
    /**
     * Get internationalCssName value
     * @return \StructType\XFkType|null
     */
    public function getInternationalCssName()
    {
        return $this->internationalCssName;
    }
    /**
     * Set internationalCssName value
     * @param \StructType\XFkType $internationalCssName
     * @return \StructType\RTransformationProfile
     */
    public function setInternationalCssName(\StructType\XFkType $internationalCssName = null)
    {
        $this->internationalCssName = $internationalCssName;
        return $this;
    }
    /**
     * Get unknownCssName value
     * @return \StructType\XFkType|null
     */
    public function getUnknownCssName()
    {
        return $this->unknownCssName;
    }
    /**
     * Set unknownCssName value
     * @param \StructType\XFkType $unknownCssName
     * @return \StructType\RTransformationProfile
     */
    public function setUnknownCssName(\StructType\XFkType $unknownCssName = null)
    {
        $this->unknownCssName = $unknownCssName;
        return $this;
    }
    /**
     * Get subscriberCssName value
     * @return \StructType\XFkType|null
     */
    public function getSubscriberCssName()
    {
        return $this->subscriberCssName;
    }
    /**
     * Set subscriberCssName value
     * @param \StructType\XFkType $subscriberCssName
     * @return \StructType\RTransformationProfile
     */
    public function setSubscriberCssName(\StructType\XFkType $subscriberCssName = null)
    {
        $this->subscriberCssName = $subscriberCssName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RTransformationProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
