<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSoftKeySet StructType
 * @subpackage Structs
 */
class RSoftKeySet extends AbstractStructBase
{
    /**
     * The softKeyTemplateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softKeyTemplateName;
    /**
     * The callStates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CallStates
     */
    public $callStates;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSoftKeySet
     * @uses RSoftKeySet::setSoftKeyTemplateName()
     * @uses RSoftKeySet::setCallStates()
     * @uses RSoftKeySet::setUuid()
     * @param \StructType\XFkType $softKeyTemplateName
     * @param \StructType\CallStates $callStates
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $softKeyTemplateName = null, \StructType\CallStates $callStates = null, $uuid = null)
    {
        $this
            ->setSoftKeyTemplateName($softKeyTemplateName)
            ->setCallStates($callStates)
            ->setUuid($uuid);
    }
    /**
     * Get softKeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getSoftKeyTemplateName()
    {
        return $this->softKeyTemplateName;
    }
    /**
     * Set softKeyTemplateName value
     * @param \StructType\XFkType $softKeyTemplateName
     * @return \StructType\RSoftKeySet
     */
    public function setSoftKeyTemplateName(\StructType\XFkType $softKeyTemplateName = null)
    {
        $this->softKeyTemplateName = $softKeyTemplateName;
        return $this;
    }
    /**
     * Get callStates value
     * @return \StructType\CallStates|null
     */
    public function getCallStates()
    {
        return $this->callStates;
    }
    /**
     * Set callStates value
     * @param \StructType\CallStates $callStates
     * @return \StructType\RSoftKeySet
     */
    public function setCallStates(\StructType\CallStates $callStates = null)
    {
        $this->callStates = $callStates;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RSoftKeySet
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
