<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RServiceParameter StructType
 * @subpackage Structs
 */
class RServiceParameter extends AbstractStructBase
{
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - documentation: The process Node that this the service parameter belongs to. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $processNodeName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of the service parameter. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - documentation: The service that this service parameter belongs to.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The valueType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $valueType;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RServiceParameter
     * @uses RServiceParameter::setProcessNodeName()
     * @uses RServiceParameter::setName()
     * @uses RServiceParameter::setService()
     * @uses RServiceParameter::setValue()
     * @uses RServiceParameter::setValueType()
     * @uses RServiceParameter::setUuid()
     * @param \StructType\XFkType $processNodeName
     * @param string $name
     * @param string $service
     * @param string $value
     * @param string $valueType
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $processNodeName = null, $name = null, $service = null, $value = null, $valueType = null, $uuid = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setName($name)
            ->setService($service)
            ->setValue($value)
            ->setValueType($valueType)
            ->setUuid($uuid);
    }
    /**
     * Get processNodeName value
     * @return \StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \StructType\XFkType $processNodeName
     * @return \StructType\RServiceParameter
     */
    public function setProcessNodeName(\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RServiceParameter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \EnumType\XService::valueIsValid()
     * @uses \EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \StructType\RServiceParameter
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XService', is_array($service) ? implode(', ', $service) : var_export($service, true), implode(', ', \EnumType\XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\RServiceParameter
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get valueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->valueType;
    }
    /**
     * Set valueType value
     * @uses \EnumType\XParam::valueIsValid()
     * @uses \EnumType\XParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \StructType\RServiceParameter
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XParam::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XParam', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \EnumType\XParam::getValidValues())), __LINE__);
        }
        $this->valueType = $valueType;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RServiceParameter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
