<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRecordingProfile StructType
 * @subpackage Structs
 */
class RRecordingProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The recordingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $recordingCssName;
    /**
     * The recorderDestination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recorderDestination;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRecordingProfile
     * @uses RRecordingProfile::setName()
     * @uses RRecordingProfile::setRecordingCssName()
     * @uses RRecordingProfile::setRecorderDestination()
     * @uses RRecordingProfile::setUuid()
     * @param string $name
     * @param \StructType\XFkType $recordingCssName
     * @param string $recorderDestination
     * @param string $uuid
     */
    public function __construct($name = null, \StructType\XFkType $recordingCssName = null, $recorderDestination = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setRecordingCssName($recordingCssName)
            ->setRecorderDestination($recorderDestination)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RRecordingProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get recordingCssName value
     * @return \StructType\XFkType|null
     */
    public function getRecordingCssName()
    {
        return $this->recordingCssName;
    }
    /**
     * Set recordingCssName value
     * @param \StructType\XFkType $recordingCssName
     * @return \StructType\RRecordingProfile
     */
    public function setRecordingCssName(\StructType\XFkType $recordingCssName = null)
    {
        $this->recordingCssName = $recordingCssName;
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string|null
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return \StructType\RRecordingProfile
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        // validation for constraint: string
        if (!is_null($recorderDestination) && !is_string($recorderDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recorderDestination, true), gettype($recorderDestination)), __LINE__);
        }
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RRecordingProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
