<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RProcessNode StructType
 * @subpackage Structs
 */
class RProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv6Name;
    /**
     * The nodeUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodeUsage;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $processNodeRole;
    /**
     * The cupDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RProcessNode
     * @uses RProcessNode::setName()
     * @uses RProcessNode::setDescription()
     * @uses RProcessNode::setMac()
     * @uses RProcessNode::setIpv6Name()
     * @uses RProcessNode::setNodeUsage()
     * @uses RProcessNode::setLbmHubGroup()
     * @uses RProcessNode::setProcessNodeRole()
     * @uses RProcessNode::setCupDomain()
     * @uses RProcessNode::setUuid()
     * @param string $name
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param string $nodeUsage
     * @param \StructType\XFkType $lbmHubGroup
     * @param string $processNodeRole
     * @param string $cupDomain
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $mac = null, $ipv6Name = null, $nodeUsage = null, \StructType\XFkType $lbmHubGroup = null, $processNodeRole = null, $cupDomain = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setNodeUsage($nodeUsage)
            ->setLbmHubGroup($lbmHubGroup)
            ->setProcessNodeRole($processNodeRole)
            ->setCupDomain($cupDomain)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RProcessNode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($name) && mb_strlen($name) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RProcessNode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \StructType\RProcessNode
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mac, true), gettype($mac)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]|[a-f]|[A-F]){12})
        if (!is_null($mac) && !preg_match('/([0-9]|[a-f]|[A-F]){12}/', $mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]|[a-f]|[A-F]){12}', var_export($mac, true)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \StructType\RProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Name) && !is_string($ipv6Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipv6Name, true), gettype($ipv6Name)), __LINE__);
        }
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get nodeUsage value
     * @return string|null
     */
    public function getNodeUsage()
    {
        return $this->nodeUsage;
    }
    /**
     * Set nodeUsage value
     * @uses \EnumType\XNodeUsage::valueIsValid()
     * @uses \EnumType\XNodeUsage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nodeUsage
     * @return \StructType\RProcessNode
     */
    public function setNodeUsage($nodeUsage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNodeUsage::valueIsValid($nodeUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XNodeUsage', is_array($nodeUsage) ? implode(', ', $nodeUsage) : var_export($nodeUsage, true), implode(', ', \EnumType\XNodeUsage::getValidValues())), __LINE__);
        }
        $this->nodeUsage = $nodeUsage;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * @return \StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return $this->lbmHubGroup;
    }
    /**
     * Set lbmHubGroup value
     * @param \StructType\XFkType $lbmHubGroup
     * @return \StructType\RProcessNode
     */
    public function setLbmHubGroup(\StructType\XFkType $lbmHubGroup = null)
    {
        $this->lbmHubGroup = $lbmHubGroup;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string|null
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @uses \EnumType\XProcessNodeRole::valueIsValid()
     * @uses \EnumType\XProcessNodeRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processNodeRole
     * @return \StructType\RProcessNode
     */
    public function setProcessNodeRole($processNodeRole = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProcessNodeRole::valueIsValid($processNodeRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProcessNodeRole', is_array($processNodeRole) ? implode(', ', $processNodeRole) : var_export($processNodeRole, true), implode(', ', \EnumType\XProcessNodeRole::getValidValues())), __LINE__);
        }
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \StructType\RProcessNode
     */
    public function setCupDomain($cupDomain = null)
    {
        // validation for constraint: string
        if (!is_null($cupDomain) && !is_string($cupDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cupDomain, true), gettype($cupDomain)), __LINE__);
        }
        $this->cupDomain = $cupDomain;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RProcessNode
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
