<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPhoneButtonTemplate StructType
 * @subpackage Structs
 */
class RPhoneButtonTemplate extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The template's name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The isUserModifiable
     * Meta information extracted from the WSDL
     * - documentation: Read-only
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isUserModifiable;
    /**
     * The buttons
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Buttons
     */
    public $buttons;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPhoneButtonTemplate
     * @uses RPhoneButtonTemplate::setName()
     * @uses RPhoneButtonTemplate::setIsUserModifiable()
     * @uses RPhoneButtonTemplate::setButtons()
     * @uses RPhoneButtonTemplate::setUuid()
     * @param string $name
     * @param string $isUserModifiable
     * @param \StructType\Buttons $buttons
     * @param string $uuid
     */
    public function __construct($name = null, $isUserModifiable = null, \StructType\Buttons $buttons = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setIsUserModifiable($isUserModifiable)
            ->setButtons($buttons)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RPhoneButtonTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get isUserModifiable value
     * @return string|null
     */
    public function getIsUserModifiable()
    {
        return $this->isUserModifiable;
    }
    /**
     * Set isUserModifiable value
     * @param string $isUserModifiable
     * @return \StructType\RPhoneButtonTemplate
     */
    public function setIsUserModifiable($isUserModifiable = null)
    {
        // validation for constraint: string
        if (!is_null($isUserModifiable) && !is_string($isUserModifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isUserModifiable, true), gettype($isUserModifiable)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isUserModifiable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isUserModifiable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isUserModifiable, true)), __LINE__);
        }
        $this->isUserModifiable = $isUserModifiable;
        return $this;
    }
    /**
     * Get buttons value
     * @return \StructType\Buttons|null
     */
    public function getButtons()
    {
        return $this->buttons;
    }
    /**
     * Set buttons value
     * @param \StructType\Buttons $buttons
     * @return \StructType\RPhoneButtonTemplate
     */
    public function setButtons(\StructType\Buttons $buttons = null)
    {
        $this->buttons = $buttons;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RPhoneButtonTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
