<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLocation StructType
 * @subpackage Structs
 */
class RLocation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Read only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The relatedLocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RelatedLocations
     */
    public $relatedLocations;
    /**
     * The withinAudioBandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinAudioBandwidth;
    /**
     * The withinVideoBandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinVideoBandwidth;
    /**
     * The withinImmersiveKbits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $withinImmersiveKbits;
    /**
     * The betweenLocations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BetweenLocations
     */
    public $betweenLocations;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLocation
     * @uses RLocation::setName()
     * @uses RLocation::setId()
     * @uses RLocation::setRelatedLocations()
     * @uses RLocation::setWithinAudioBandwidth()
     * @uses RLocation::setWithinVideoBandwidth()
     * @uses RLocation::setWithinImmersiveKbits()
     * @uses RLocation::setBetweenLocations()
     * @uses RLocation::setUuid()
     * @param string $name
     * @param string $id
     * @param \StructType\RelatedLocations $relatedLocations
     * @param string $withinAudioBandwidth
     * @param string $withinVideoBandwidth
     * @param string $withinImmersiveKbits
     * @param \StructType\BetweenLocations $betweenLocations
     * @param string $uuid
     */
    public function __construct($name = null, $id = null, \StructType\RelatedLocations $relatedLocations = null, $withinAudioBandwidth = null, $withinVideoBandwidth = null, $withinImmersiveKbits = null, \StructType\BetweenLocations $betweenLocations = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setId($id)
            ->setRelatedLocations($relatedLocations)
            ->setWithinAudioBandwidth($withinAudioBandwidth)
            ->setWithinVideoBandwidth($withinVideoBandwidth)
            ->setWithinImmersiveKbits($withinImmersiveKbits)
            ->setBetweenLocations($betweenLocations)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \StructType\RLocation
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($id) ? implode(', ', $id) : var_export($id, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return \StructType\RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param \StructType\RelatedLocations $relatedLocations
     * @return \StructType\RLocation
     */
    public function setRelatedLocations(\StructType\RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Get withinAudioBandwidth value
     * @return string|null
     */
    public function getWithinAudioBandwidth()
    {
        return $this->withinAudioBandwidth;
    }
    /**
     * Set withinAudioBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinAudioBandwidth
     * @return \StructType\RLocation
     */
    public function setWithinAudioBandwidth($withinAudioBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinAudioBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($withinAudioBandwidth) ? implode(', ', $withinAudioBandwidth) : var_export($withinAudioBandwidth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinAudioBandwidth = $withinAudioBandwidth;
        return $this;
    }
    /**
     * Get withinVideoBandwidth value
     * @return string|null
     */
    public function getWithinVideoBandwidth()
    {
        return $this->withinVideoBandwidth;
    }
    /**
     * Set withinVideoBandwidth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinVideoBandwidth
     * @return \StructType\RLocation
     */
    public function setWithinVideoBandwidth($withinVideoBandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinVideoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($withinVideoBandwidth) ? implode(', ', $withinVideoBandwidth) : var_export($withinVideoBandwidth, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinVideoBandwidth = $withinVideoBandwidth;
        return $this;
    }
    /**
     * Get withinImmersiveKbits value
     * @return string|null
     */
    public function getWithinImmersiveKbits()
    {
        return $this->withinImmersiveKbits;
    }
    /**
     * Set withinImmersiveKbits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $withinImmersiveKbits
     * @return \StructType\RLocation
     */
    public function setWithinImmersiveKbits($withinImmersiveKbits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($withinImmersiveKbits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($withinImmersiveKbits) ? implode(', ', $withinImmersiveKbits) : var_export($withinImmersiveKbits, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->withinImmersiveKbits = $withinImmersiveKbits;
        return $this;
    }
    /**
     * Get betweenLocations value
     * @return \StructType\BetweenLocations|null
     */
    public function getBetweenLocations()
    {
        return $this->betweenLocations;
    }
    /**
     * Set betweenLocations value
     * @param \StructType\BetweenLocations $betweenLocations
     * @return \StructType\RLocation
     */
    public function setBetweenLocations(\StructType\BetweenLocations $betweenLocations = null)
    {
        $this->betweenLocations = $betweenLocations;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RLocation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
