<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RIpPhoneServicesParameter StructType
 * @subpackage Structs
 */
class RIpPhoneServicesParameter extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The default
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $default;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The paramRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $paramRequired;
    /**
     * The paramPassword
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $paramPassword;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RIpPhoneServicesParameter
     * @uses RIpPhoneServicesParameter::setName()
     * @uses RIpPhoneServicesParameter::setDisplayName()
     * @uses RIpPhoneServicesParameter::setDefault()
     * @uses RIpPhoneServicesParameter::setDescription()
     * @uses RIpPhoneServicesParameter::setParamRequired()
     * @uses RIpPhoneServicesParameter::setParamPassword()
     * @uses RIpPhoneServicesParameter::setUuid()
     * @param string $name
     * @param string $displayName
     * @param string $default
     * @param string $description
     * @param string $paramRequired
     * @param string $paramPassword
     * @param string $uuid
     */
    public function __construct($name = null, $displayName = null, $default = null, $description = null, $paramRequired = null, $paramPassword = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDisplayName($displayName)
            ->setDefault($default)
            ->setDescription($description)
            ->setParamRequired($paramRequired)
            ->setParamPassword($paramPassword)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($displayName) && mb_strlen($displayName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get default value
     * @return string|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * Set default value
     * @param string $default
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setDefault($default = null)
    {
        // validation for constraint: string
        if (!is_null($default) && !is_string($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($default, true), gettype($default)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($default) && mb_strlen($default) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($default)), __LINE__);
        }
        $this->default = $default;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get paramRequired value
     * @return string|null
     */
    public function getParamRequired()
    {
        return $this->paramRequired;
    }
    /**
     * Set paramRequired value
     * @param string $paramRequired
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setParamRequired($paramRequired = null)
    {
        // validation for constraint: string
        if (!is_null($paramRequired) && !is_string($paramRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramRequired, true), gettype($paramRequired)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($paramRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $paramRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($paramRequired, true)), __LINE__);
        }
        $this->paramRequired = $paramRequired;
        return $this;
    }
    /**
     * Get paramPassword value
     * @return string|null
     */
    public function getParamPassword()
    {
        return $this->paramPassword;
    }
    /**
     * Set paramPassword value
     * @param string $paramPassword
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setParamPassword($paramPassword = null)
    {
        // validation for constraint: string
        if (!is_null($paramPassword) && !is_string($paramPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paramPassword, true), gettype($paramPassword)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($paramPassword) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $paramPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($paramPassword, true)), __LINE__);
        }
        $this->paramPassword = $paramPassword;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RIpPhoneServicesParameter
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
