<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAppUser StructType
 * @subpackage Structs
 */
class RAppUser extends AbstractStructBase
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-127 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-42 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The isStandard
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The associatedCapfProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAppUser
     * @uses RAppUser::setUserid()
     * @uses RAppUser::setPassword()
     * @uses RAppUser::setPasswordCredentials()
     * @uses RAppUser::setDigestCredentials()
     * @uses RAppUser::setPresenceGroupName()
     * @uses RAppUser::setAcceptPresenceSubscription()
     * @uses RAppUser::setAcceptOutOfDialogRefer()
     * @uses RAppUser::setAcceptUnsolicitedNotification()
     * @uses RAppUser::setAllowReplaceHeader()
     * @uses RAppUser::setIsStandard()
     * @uses RAppUser::setAssociatedDevices()
     * @uses RAppUser::setAssociatedGroups()
     * @uses RAppUser::setAssociatedCapfProfiles()
     * @uses RAppUser::setCtiControlledDeviceProfiles()
     * @uses RAppUser::setUuid()
     * @param string $userid
     * @param string $password
     * @param \StructType\PasswordCredentials $passwordCredentials
     * @param string $digestCredentials
     * @param \StructType\XFkType $presenceGroupName
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $isStandard
     * @param \StructType\AssociatedDevices $associatedDevices
     * @param \StructType\AssociatedGroups $associatedGroups
     * @param \StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $uuid
     */
    public function __construct($userid = null, $password = null, \StructType\PasswordCredentials $passwordCredentials = null, $digestCredentials = null, \StructType\XFkType $presenceGroupName = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $isStandard = null, \StructType\AssociatedDevices $associatedDevices = null, \StructType\AssociatedGroups $associatedGroups = null, \StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPasswordCredentials($passwordCredentials)
            ->setDigestCredentials($digestCredentials)
            ->setPresenceGroupName($presenceGroupName)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setIsStandard($isStandard)
            ->setAssociatedDevices($associatedDevices)
            ->setAssociatedGroups($associatedGroups)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\RAppUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userid, true), gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\RAppUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \StructType\PasswordCredentials $passwordCredentials
     * @return \StructType\RAppUser
     */
    public function setPasswordCredentials(\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \StructType\RAppUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($digestCredentials, true), gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\RAppUser
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \StructType\RAppUser
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptPresenceSubscription, true), gettype($acceptPresenceSubscription)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \StructType\RAppUser
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptOutOfDialogRefer, true), gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \StructType\RAppUser
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptUnsolicitedNotification, true), gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \StructType\RAppUser
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowReplaceHeader, true), gettype($allowReplaceHeader)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($allowReplaceHeader, true)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string|null
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \StructType\RAppUser
     */
    public function setIsStandard($isStandard = null)
    {
        // validation for constraint: string
        if (!is_null($isStandard) && !is_string($isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isStandard, true), gettype($isStandard)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isStandard) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isStandard, true)), __LINE__);
        }
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \StructType\AssociatedDevices $associatedDevices
     * @return \StructType\RAppUser
     */
    public function setAssociatedDevices(\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \StructType\AssociatedGroups $associatedGroups
     * @return \StructType\RAppUser
     */
    public function setAssociatedGroups(\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \StructType\RAppUser
     */
    public function setAssociatedCapfProfiles(\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \StructType\RAppUser
     */
    public function setCtiControlledDeviceProfiles(\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAppUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
