<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAppServerInfo StructType
 * @subpackage Structs
 */
class RAppServerInfo extends AbstractStructBase
{
    /**
     * The appServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $appServerName;
    /**
     * The appServerContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerContent;
    /**
     * The content
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XContent
     */
    public $content;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAppServerInfo
     * @uses RAppServerInfo::setAppServerName()
     * @uses RAppServerInfo::setAppServerContent()
     * @uses RAppServerInfo::setContent()
     * @uses RAppServerInfo::setUuid()
     * @param \StructType\XFkType $appServerName
     * @param string $appServerContent
     * @param \StructType\XContent $content
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $appServerName = null, $appServerContent = null, \StructType\XContent $content = null, $uuid = null)
    {
        $this
            ->setAppServerName($appServerName)
            ->setAppServerContent($appServerContent)
            ->setContent($content)
            ->setUuid($uuid);
    }
    /**
     * Get appServerName value
     * @return \StructType\XFkType|null
     */
    public function getAppServerName()
    {
        return $this->appServerName;
    }
    /**
     * Set appServerName value
     * @param \StructType\XFkType $appServerName
     * @return \StructType\RAppServerInfo
     */
    public function setAppServerName(\StructType\XFkType $appServerName = null)
    {
        $this->appServerName = $appServerName;
        return $this;
    }
    /**
     * Get appServerContent value
     * @return string|null
     */
    public function getAppServerContent()
    {
        return $this->appServerContent;
    }
    /**
     * Set appServerContent value
     * @uses \EnumType\XAppServerContent::valueIsValid()
     * @uses \EnumType\XAppServerContent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerContent
     * @return \StructType\RAppServerInfo
     */
    public function setAppServerContent($appServerContent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAppServerContent::valueIsValid($appServerContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XAppServerContent', is_array($appServerContent) ? implode(', ', $appServerContent) : var_export($appServerContent, true), implode(', ', \EnumType\XAppServerContent::getValidValues())), __LINE__);
        }
        $this->appServerContent = $appServerContent;
        return $this;
    }
    /**
     * Get content value
     * @return \StructType\XContent|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param \StructType\XContent $content
     * @return \StructType\RAppServerInfo
     */
    public function setContent(\StructType\XContent $content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAppServerInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
