<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAccessControlGroupName StructType
 * @subpackage Structs
 */
class RAccessControlGroupName extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAccessControlGroupName
     * @uses RAccessControlGroupName::setName()
     * @uses RAccessControlGroupName::setUuid()
     * @param \StructType\XFkType $name
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $name = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return \StructType\XFkType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\XFkType $name
     * @return \StructType\RAccessControlGroupName
     */
    public function setName(\StructType\XFkType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RAccessControlGroupName
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
