<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for primaryExtension StructType
 * Meta information extracted from the WSDL
 * - documentation: Only DNs associated with the associatedDevices of the User can be used as primary extension.
 * @subpackage Structs
 */
class PrimaryExtension extends AbstractStructBase
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - documentation: DN or Pattern
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - documentation: Route Partition to which the DN is associated.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartitionName;
    /**
     * Constructor method for primaryExtension
     * @uses PrimaryExtension::setPattern()
     * @uses PrimaryExtension::setRoutePartitionName()
     * @param string $pattern
     * @param string $routePartitionName
     */
    public function __construct($pattern = null, $routePartitionName = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\PrimaryExtension
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pattern, true), gettype($pattern)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($pattern) && mb_strlen($pattern) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return string|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param string $routePartitionName
     * @return \StructType\PrimaryExtension
     */
    public function setRoutePartitionName($routePartitionName = null)
    {
        // validation for constraint: string
        if (!is_null($routePartitionName) && !is_string($routePartitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routePartitionName, true), gettype($routePartitionName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($routePartitionName) && mb_strlen($routePartitionName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($routePartitionName)), __LINE__);
        }
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
}
