<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectList StructType
 * @subpackage Structs
 */
class ObjectList extends AbstractStructBase
{
    /**
     * The object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $object;
    /**
     * Constructor method for objectList
     * @uses ObjectList::setObject()
     * @param string[] $object
     */
    public function __construct(array $object = array())
    {
        $this
            ->setObject($object);
    }
    /**
     * Get object value
     * @return string[]|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $objectListObjectItem) {
            // validation for constraint: enumeration
            if (!\EnumType\XChangeType::valueIsValid($objectListObjectItem)) {
                $invalidValues[] = is_object($objectListObjectItem) ? get_class($objectListObjectItem) : sprintf('%s(%s)', gettype($objectListObjectItem), var_export($objectListObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XChangeType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\XChangeType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set object value
     * @uses \EnumType\XChangeType::valueIsValid()
     * @uses \EnumType\XChangeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $object
     * @return \StructType\ObjectList
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new \InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Add item to object value
     * @uses \EnumType\XChangeType::valueIsValid()
     * @uses \EnumType\XChangeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ObjectList
     */
    public function addToObject($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XChangeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XChangeType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\XChangeType::getValidValues())), __LINE__);
        }
        $this->object[] = $item;
        return $this;
    }
}
