<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OXTransPattern StructType
 * @subpackage Structs
 */
class OXTransPattern extends AbstractStructBase
{
    /**
     * The usage
     * Meta information extracted from the WSDL
     * - documentation: For Intercom DN and Intercom Translation patterns the usage tag value needs to be specified explicitly as Device Intercom and Translation Intercom respectively. For all other patterns it is a Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $usage;
    /**
     * The routePartitionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $routePartitionName;
    /**
     * The useCallingPartyPhoneMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $useCallingPartyPhoneMask;
    /**
     * The dialPlanName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $dialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The routeFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $routeFilterName;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingLinePresentationBit;
    /**
     * The callingNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingNamePresentationBit;
    /**
     * The connectedLinePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $connectedLinePresentationBit;
    /**
     * The connectedNamePresentationBit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $connectedNamePresentationBit;
    /**
     * The patternPrecedence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $patternPrecedence;
    /**
     * The callingPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingPartyNumberingPlan;
    /**
     * The callingPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingPartyNumberType;
    /**
     * The calledPartyNumberingPlan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $calledPartyNumberType;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callingSearchSpaceName;
    /**
     * The resourcePriorityNamespaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $resourcePriorityNamespaceName;
    /**
     * The routeClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $routeClass;
    /**
     * The callInterceptProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $callInterceptProfileName;
    /**
     * The releaseClause
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OXFkType
     */
    public $releaseClause;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for OXTransPattern
     * @uses OXTransPattern::setUsage()
     * @uses OXTransPattern::setRoutePartitionName()
     * @uses OXTransPattern::setUseCallingPartyPhoneMask()
     * @uses OXTransPattern::setDialPlanName()
     * @uses OXTransPattern::setDigitDiscardInstructionName()
     * @uses OXTransPattern::setRouteFilterName()
     * @uses OXTransPattern::setCallingLinePresentationBit()
     * @uses OXTransPattern::setCallingNamePresentationBit()
     * @uses OXTransPattern::setConnectedLinePresentationBit()
     * @uses OXTransPattern::setConnectedNamePresentationBit()
     * @uses OXTransPattern::setPatternPrecedence()
     * @uses OXTransPattern::setCallingPartyNumberingPlan()
     * @uses OXTransPattern::setCallingPartyNumberType()
     * @uses OXTransPattern::setCalledPartyNumberingPlan()
     * @uses OXTransPattern::setCalledPartyNumberType()
     * @uses OXTransPattern::setCallingSearchSpaceName()
     * @uses OXTransPattern::setResourcePriorityNamespaceName()
     * @uses OXTransPattern::setRouteClass()
     * @uses OXTransPattern::setCallInterceptProfileName()
     * @uses OXTransPattern::setReleaseClause()
     * @uses OXTransPattern::setUuid()
     * @param \StructType\OXFkType $usage
     * @param \StructType\OXFkType $routePartitionName
     * @param \StructType\OXFkType $useCallingPartyPhoneMask
     * @param \StructType\OXFkType $dialPlanName
     * @param \StructType\OXFkType $digitDiscardInstructionName
     * @param \StructType\OXFkType $routeFilterName
     * @param \StructType\OXFkType $callingLinePresentationBit
     * @param \StructType\OXFkType $callingNamePresentationBit
     * @param \StructType\OXFkType $connectedLinePresentationBit
     * @param \StructType\OXFkType $connectedNamePresentationBit
     * @param \StructType\OXFkType $patternPrecedence
     * @param \StructType\OXFkType $callingPartyNumberingPlan
     * @param \StructType\OXFkType $callingPartyNumberType
     * @param \StructType\OXFkType $calledPartyNumberingPlan
     * @param \StructType\OXFkType $calledPartyNumberType
     * @param \StructType\OXFkType $callingSearchSpaceName
     * @param \StructType\OXFkType $resourcePriorityNamespaceName
     * @param \StructType\OXFkType $routeClass
     * @param \StructType\OXFkType $callInterceptProfileName
     * @param \StructType\OXFkType $releaseClause
     * @param string $uuid
     */
    public function __construct(\StructType\OXFkType $usage = null, \StructType\OXFkType $routePartitionName = null, \StructType\OXFkType $useCallingPartyPhoneMask = null, \StructType\OXFkType $dialPlanName = null, \StructType\OXFkType $digitDiscardInstructionName = null, \StructType\OXFkType $routeFilterName = null, \StructType\OXFkType $callingLinePresentationBit = null, \StructType\OXFkType $callingNamePresentationBit = null, \StructType\OXFkType $connectedLinePresentationBit = null, \StructType\OXFkType $connectedNamePresentationBit = null, \StructType\OXFkType $patternPrecedence = null, \StructType\OXFkType $callingPartyNumberingPlan = null, \StructType\OXFkType $callingPartyNumberType = null, \StructType\OXFkType $calledPartyNumberingPlan = null, \StructType\OXFkType $calledPartyNumberType = null, \StructType\OXFkType $callingSearchSpaceName = null, \StructType\OXFkType $resourcePriorityNamespaceName = null, \StructType\OXFkType $routeClass = null, \StructType\OXFkType $callInterceptProfileName = null, \StructType\OXFkType $releaseClause = null, $uuid = null)
    {
        $this
            ->setUsage($usage)
            ->setRoutePartitionName($routePartitionName)
            ->setUseCallingPartyPhoneMask($useCallingPartyPhoneMask)
            ->setDialPlanName($dialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setRouteFilterName($routeFilterName)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setCallingNamePresentationBit($callingNamePresentationBit)
            ->setConnectedLinePresentationBit($connectedLinePresentationBit)
            ->setConnectedNamePresentationBit($connectedNamePresentationBit)
            ->setPatternPrecedence($patternPrecedence)
            ->setCallingPartyNumberingPlan($callingPartyNumberingPlan)
            ->setCallingPartyNumberType($callingPartyNumberType)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setResourcePriorityNamespaceName($resourcePriorityNamespaceName)
            ->setRouteClass($routeClass)
            ->setCallInterceptProfileName($callInterceptProfileName)
            ->setReleaseClause($releaseClause)
            ->setUuid($uuid);
    }
    /**
     * Get usage value
     * @return \StructType\OXFkType|null
     */
    public function getUsage()
    {
        return $this->usage;
    }
    /**
     * Set usage value
     * @param \StructType\OXFkType $usage
     * @return \StructType\OXTransPattern
     */
    public function setUsage(\StructType\OXFkType $usage = null)
    {
        $this->usage = $usage;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\OXFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\OXFkType $routePartitionName
     * @return \StructType\OXTransPattern
     */
    public function setRoutePartitionName(\StructType\OXFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get useCallingPartyPhoneMask value
     * @return \StructType\OXFkType|null
     */
    public function getUseCallingPartyPhoneMask()
    {
        return $this->useCallingPartyPhoneMask;
    }
    /**
     * Set useCallingPartyPhoneMask value
     * @param \StructType\OXFkType $useCallingPartyPhoneMask
     * @return \StructType\OXTransPattern
     */
    public function setUseCallingPartyPhoneMask(\StructType\OXFkType $useCallingPartyPhoneMask = null)
    {
        $this->useCallingPartyPhoneMask = $useCallingPartyPhoneMask;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \StructType\OXFkType|null
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \StructType\OXFkType $dialPlanName
     * @return \StructType\OXTransPattern
     */
    public function setDialPlanName(\StructType\OXFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * @return \StructType\OXFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return $this->digitDiscardInstructionName;
    }
    /**
     * Set digitDiscardInstructionName value
     * @param \StructType\OXFkType $digitDiscardInstructionName
     * @return \StructType\OXTransPattern
     */
    public function setDigitDiscardInstructionName(\StructType\OXFkType $digitDiscardInstructionName = null)
    {
        $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        return $this;
    }
    /**
     * Get routeFilterName value
     * @return \StructType\OXFkType|null
     */
    public function getRouteFilterName()
    {
        return $this->routeFilterName;
    }
    /**
     * Set routeFilterName value
     * @param \StructType\OXFkType $routeFilterName
     * @return \StructType\OXTransPattern
     */
    public function setRouteFilterName(\StructType\OXFkType $routeFilterName = null)
    {
        $this->routeFilterName = $routeFilterName;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return \StructType\OXFkType|null
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param \StructType\OXFkType $callingLinePresentationBit
     * @return \StructType\OXTransPattern
     */
    public function setCallingLinePresentationBit(\StructType\OXFkType $callingLinePresentationBit = null)
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get callingNamePresentationBit value
     * @return \StructType\OXFkType|null
     */
    public function getCallingNamePresentationBit()
    {
        return $this->callingNamePresentationBit;
    }
    /**
     * Set callingNamePresentationBit value
     * @param \StructType\OXFkType $callingNamePresentationBit
     * @return \StructType\OXTransPattern
     */
    public function setCallingNamePresentationBit(\StructType\OXFkType $callingNamePresentationBit = null)
    {
        $this->callingNamePresentationBit = $callingNamePresentationBit;
        return $this;
    }
    /**
     * Get connectedLinePresentationBit value
     * @return \StructType\OXFkType|null
     */
    public function getConnectedLinePresentationBit()
    {
        return $this->connectedLinePresentationBit;
    }
    /**
     * Set connectedLinePresentationBit value
     * @param \StructType\OXFkType $connectedLinePresentationBit
     * @return \StructType\OXTransPattern
     */
    public function setConnectedLinePresentationBit(\StructType\OXFkType $connectedLinePresentationBit = null)
    {
        $this->connectedLinePresentationBit = $connectedLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedNamePresentationBit value
     * @return \StructType\OXFkType|null
     */
    public function getConnectedNamePresentationBit()
    {
        return $this->connectedNamePresentationBit;
    }
    /**
     * Set connectedNamePresentationBit value
     * @param \StructType\OXFkType $connectedNamePresentationBit
     * @return \StructType\OXTransPattern
     */
    public function setConnectedNamePresentationBit(\StructType\OXFkType $connectedNamePresentationBit = null)
    {
        $this->connectedNamePresentationBit = $connectedNamePresentationBit;
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return \StructType\OXFkType|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @param \StructType\OXFkType $patternPrecedence
     * @return \StructType\OXTransPattern
     */
    public function setPatternPrecedence(\StructType\OXFkType $patternPrecedence = null)
    {
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get callingPartyNumberingPlan value
     * @return \StructType\OXFkType|null
     */
    public function getCallingPartyNumberingPlan()
    {
        return $this->callingPartyNumberingPlan;
    }
    /**
     * Set callingPartyNumberingPlan value
     * @param \StructType\OXFkType $callingPartyNumberingPlan
     * @return \StructType\OXTransPattern
     */
    public function setCallingPartyNumberingPlan(\StructType\OXFkType $callingPartyNumberingPlan = null)
    {
        $this->callingPartyNumberingPlan = $callingPartyNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNumberType value
     * @return \StructType\OXFkType|null
     */
    public function getCallingPartyNumberType()
    {
        return $this->callingPartyNumberType;
    }
    /**
     * Set callingPartyNumberType value
     * @param \StructType\OXFkType $callingPartyNumberType
     * @return \StructType\OXTransPattern
     */
    public function setCallingPartyNumberType(\StructType\OXFkType $callingPartyNumberType = null)
    {
        $this->callingPartyNumberType = $callingPartyNumberType;
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return \StructType\OXFkType|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @param \StructType\OXFkType $calledPartyNumberingPlan
     * @return \StructType\OXTransPattern
     */
    public function setCalledPartyNumberingPlan(\StructType\OXFkType $calledPartyNumberingPlan = null)
    {
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return \StructType\OXFkType|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @param \StructType\OXFkType $calledPartyNumberType
     * @return \StructType\OXTransPattern
     */
    public function setCalledPartyNumberType(\StructType\OXFkType $calledPartyNumberType = null)
    {
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\OXFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\OXFkType $callingSearchSpaceName
     * @return \StructType\OXTransPattern
     */
    public function setCallingSearchSpaceName(\StructType\OXFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceName value
     * @return \StructType\OXFkType|null
     */
    public function getResourcePriorityNamespaceName()
    {
        return $this->resourcePriorityNamespaceName;
    }
    /**
     * Set resourcePriorityNamespaceName value
     * @param \StructType\OXFkType $resourcePriorityNamespaceName
     * @return \StructType\OXTransPattern
     */
    public function setResourcePriorityNamespaceName(\StructType\OXFkType $resourcePriorityNamespaceName = null)
    {
        $this->resourcePriorityNamespaceName = $resourcePriorityNamespaceName;
        return $this;
    }
    /**
     * Get routeClass value
     * @return \StructType\OXFkType|null
     */
    public function getRouteClass()
    {
        return $this->routeClass;
    }
    /**
     * Set routeClass value
     * @param \StructType\OXFkType $routeClass
     * @return \StructType\OXTransPattern
     */
    public function setRouteClass(\StructType\OXFkType $routeClass = null)
    {
        $this->routeClass = $routeClass;
        return $this;
    }
    /**
     * Get callInterceptProfileName value
     * @return \StructType\OXFkType|null
     */
    public function getCallInterceptProfileName()
    {
        return $this->callInterceptProfileName;
    }
    /**
     * Set callInterceptProfileName value
     * @param \StructType\OXFkType $callInterceptProfileName
     * @return \StructType\OXTransPattern
     */
    public function setCallInterceptProfileName(\StructType\OXFkType $callInterceptProfileName = null)
    {
        $this->callInterceptProfileName = $callInterceptProfileName;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return \StructType\OXFkType|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @param \StructType\OXFkType $releaseClause
     * @return \StructType\OXTransPattern
     */
    public function setReleaseClause(\StructType\OXFkType $releaseClause = null)
    {
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\OXTransPattern
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
