<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORSubscribedService StructType
 * @subpackage Structs
 */
class ORSubscribedService extends AbstractStructBase
{
    /**
     * The telecasterServiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $telecasterServiceName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORSubscribedService
     * @uses ORSubscribedService::setTelecasterServiceName()
     * @uses ORSubscribedService::setUuid()
     * @param \StructType\ORFkType $telecasterServiceName
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $telecasterServiceName = null, $uuid = null)
    {
        $this
            ->setTelecasterServiceName($telecasterServiceName)
            ->setUuid($uuid);
    }
    /**
     * Get telecasterServiceName value
     * @return \StructType\ORFkType|null
     */
    public function getTelecasterServiceName()
    {
        return $this->telecasterServiceName;
    }
    /**
     * Set telecasterServiceName value
     * @param \StructType\ORFkType $telecasterServiceName
     * @return \StructType\ORSubscribedService
     */
    public function setTelecasterServiceName(\StructType\ORFkType $telecasterServiceName = null)
    {
        $this->telecasterServiceName = $telecasterServiceName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORSubscribedService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
