<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORPhoneLine StructType
 * @subpackage Structs
 */
class ORPhoneLine extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta information extracted from the WSDL
     * - documentation: Consecutive Rings Setting. Replaces the consective ring setting on IPPhone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for IP Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $ringSettingActivePickupAlert;
    /**
     * The mwlPolicy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $mwlPolicy;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $audibleMwi;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $partitionUsage;
    /**
     * The recordingMediaSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $recordingMediaSource;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORPhoneLine
     * @uses ORPhoneLine::setDirn()
     * @uses ORPhoneLine::setRingSetting()
     * @uses ORPhoneLine::setConsecutiveRingSetting()
     * @uses ORPhoneLine::setRingSettingIdlePickupAlert()
     * @uses ORPhoneLine::setRingSettingActivePickupAlert()
     * @uses ORPhoneLine::setMwlPolicy()
     * @uses ORPhoneLine::setRecordingProfileName()
     * @uses ORPhoneLine::setMonitoringCssName()
     * @uses ORPhoneLine::setRecordingFlag()
     * @uses ORPhoneLine::setAudibleMwi()
     * @uses ORPhoneLine::setPartitionUsage()
     * @uses ORPhoneLine::setRecordingMediaSource()
     * @uses ORPhoneLine::setCtiid()
     * @uses ORPhoneLine::setUuid()
     * @param \StructType\ORDirn $dirn
     * @param \StructType\ORFkType $ringSetting
     * @param \StructType\ORFkType $consecutiveRingSetting
     * @param \StructType\ORFkType $ringSettingIdlePickupAlert
     * @param \StructType\ORFkType $ringSettingActivePickupAlert
     * @param \StructType\ORFkType $mwlPolicy
     * @param \StructType\ORFkType $recordingProfileName
     * @param \StructType\ORFkType $monitoringCssName
     * @param \StructType\ORFkType $recordingFlag
     * @param \StructType\ORFkType $audibleMwi
     * @param \StructType\ORFkType $partitionUsage
     * @param \StructType\ORFkType $recordingMediaSource
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct(\StructType\ORDirn $dirn = null, \StructType\ORFkType $ringSetting = null, \StructType\ORFkType $consecutiveRingSetting = null, \StructType\ORFkType $ringSettingIdlePickupAlert = null, \StructType\ORFkType $ringSettingActivePickupAlert = null, \StructType\ORFkType $mwlPolicy = null, \StructType\ORFkType $recordingProfileName = null, \StructType\ORFkType $monitoringCssName = null, \StructType\ORFkType $recordingFlag = null, \StructType\ORFkType $audibleMwi = null, \StructType\ORFkType $partitionUsage = null, \StructType\ORFkType $recordingMediaSource = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setMwlPolicy($mwlPolicy)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setPartitionUsage($partitionUsage)
            ->setRecordingMediaSource($recordingMediaSource)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return \StructType\ORDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\ORDirn $dirn
     * @return \StructType\ORPhoneLine
     */
    public function setDirn(\StructType\ORDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return \StructType\ORFkType|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @param \StructType\ORFkType $ringSetting
     * @return \StructType\ORPhoneLine
     */
    public function setRingSetting(\StructType\ORFkType $ringSetting = null)
    {
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return \StructType\ORFkType|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @param \StructType\ORFkType $consecutiveRingSetting
     * @return \StructType\ORPhoneLine
     */
    public function setConsecutiveRingSetting(\StructType\ORFkType $consecutiveRingSetting = null)
    {
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return \StructType\ORFkType|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @param \StructType\ORFkType $ringSettingIdlePickupAlert
     * @return \StructType\ORPhoneLine
     */
    public function setRingSettingIdlePickupAlert(\StructType\ORFkType $ringSettingIdlePickupAlert = null)
    {
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return \StructType\ORFkType|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @param \StructType\ORFkType $ringSettingActivePickupAlert
     * @return \StructType\ORPhoneLine
     */
    public function setRingSettingActivePickupAlert(\StructType\ORFkType $ringSettingActivePickupAlert = null)
    {
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return \StructType\ORFkType|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @param \StructType\ORFkType $mwlPolicy
     * @return \StructType\ORPhoneLine
     */
    public function setMwlPolicy(\StructType\ORFkType $mwlPolicy = null)
    {
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \StructType\ORFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \StructType\ORFkType $recordingProfileName
     * @return \StructType\ORPhoneLine
     */
    public function setRecordingProfileName(\StructType\ORFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \StructType\ORFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \StructType\ORFkType $monitoringCssName
     * @return \StructType\ORPhoneLine
     */
    public function setMonitoringCssName(\StructType\ORFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return \StructType\ORFkType|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param \StructType\ORFkType $recordingFlag
     * @return \StructType\ORPhoneLine
     */
    public function setRecordingFlag(\StructType\ORFkType $recordingFlag = null)
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return \StructType\ORFkType|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param \StructType\ORFkType $audibleMwi
     * @return \StructType\ORPhoneLine
     */
    public function setAudibleMwi(\StructType\ORFkType $audibleMwi = null)
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return \StructType\ORFkType|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param \StructType\ORFkType $partitionUsage
     * @return \StructType\ORPhoneLine
     */
    public function setPartitionUsage(\StructType\ORFkType $partitionUsage = null)
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get recordingMediaSource value
     * @return \StructType\ORFkType|null
     */
    public function getRecordingMediaSource()
    {
        return $this->recordingMediaSource;
    }
    /**
     * Set recordingMediaSource value
     * @param \StructType\ORFkType $recordingMediaSource
     * @return \StructType\ORPhoneLine
     */
    public function setRecordingMediaSource(\StructType\ORFkType $recordingMediaSource = null)
    {
        $this->recordingMediaSource = $recordingMediaSource;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\ORPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !(is_int($ctiid) || ctype_digit($ctiid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ctiid, true), gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
