<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORAddOnModule StructType
 * @subpackage Structs
 */
class ORAddOnModule extends AbstractStructBase
{
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ORFkType
     */
    public $model;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for ORAddOnModule
     * @uses ORAddOnModule::setModel()
     * @uses ORAddOnModule::setUuid()
     * @param \StructType\ORFkType $model
     * @param string $uuid
     */
    public function __construct(\StructType\ORFkType $model = null, $uuid = null)
    {
        $this
            ->setModel($model)
            ->setUuid($uuid);
    }
    /**
     * Get model value
     * @return \StructType\ORFkType|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param \StructType\ORFkType $model
     * @return \StructType\ORAddOnModule
     */
    public function setModel(\StructType\ORFkType $model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\ORAddOnModule
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
