<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LWifiHotspot StructType
 * @subpackage Structs
 */
class LWifiHotspot extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The ssidPrefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ssidPrefix;
    /**
     * The authenticationMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authenticationMethod;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LWifiHotspot
     * @uses LWifiHotspot::setName()
     * @uses LWifiHotspot::setDescription()
     * @uses LWifiHotspot::setSsidPrefix()
     * @uses LWifiHotspot::setAuthenticationMethod()
     * @uses LWifiHotspot::setUuid()
     * @param string $name
     * @param string $description
     * @param string $ssidPrefix
     * @param string $authenticationMethod
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $ssidPrefix = null, $authenticationMethod = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setSsidPrefix($ssidPrefix)
            ->setAuthenticationMethod($authenticationMethod)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LWifiHotspot
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LWifiHotspot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ssidPrefix value
     * @return string|null
     */
    public function getSsidPrefix()
    {
        return $this->ssidPrefix;
    }
    /**
     * Set ssidPrefix value
     * @param string $ssidPrefix
     * @return \StructType\LWifiHotspot
     */
    public function setSsidPrefix($ssidPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($ssidPrefix) && !is_string($ssidPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ssidPrefix, true), gettype($ssidPrefix)), __LINE__);
        }
        $this->ssidPrefix = $ssidPrefix;
        return $this;
    }
    /**
     * Get authenticationMethod value
     * @return string|null
     */
    public function getAuthenticationMethod()
    {
        return $this->authenticationMethod;
    }
    /**
     * Set authenticationMethod value
     * @uses \EnumType\XHotspotAuthenticationMethod::valueIsValid()
     * @uses \EnumType\XHotspotAuthenticationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMethod
     * @return \StructType\LWifiHotspot
     */
    public function setAuthenticationMethod($authenticationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHotspotAuthenticationMethod::valueIsValid($authenticationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XHotspotAuthenticationMethod', is_array($authenticationMethod) ? implode(', ', $authenticationMethod) : var_export($authenticationMethod, true), implode(', ', \EnumType\XHotspotAuthenticationMethod::getValidValues())), __LINE__);
        }
        $this->authenticationMethod = $authenticationMethod;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LWifiHotspot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
