<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LVoiceMailPilot StructType
 * @subpackage Structs
 */
class LVoiceMailPilot extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dirn;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The cssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cssName;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - documentation: In Update setting isDefault tag as false would not disable this VoiceMailPilot as Default. Instead, the corresponding tag of another VoiceMailPilot should be set to true.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LVoiceMailPilot
     * @uses LVoiceMailPilot::setDirn()
     * @uses LVoiceMailPilot::setDescription()
     * @uses LVoiceMailPilot::setCssName()
     * @uses LVoiceMailPilot::setIsDefault()
     * @uses LVoiceMailPilot::setUuid()
     * @param string $dirn
     * @param string $description
     * @param \StructType\XFkType $cssName
     * @param string $isDefault
     * @param string $uuid
     */
    public function __construct($dirn = null, $description = null, \StructType\XFkType $cssName = null, $isDefault = null, $uuid = null)
    {
        $this
            ->setDirn($dirn)
            ->setDescription($description)
            ->setCssName($cssName)
            ->setIsDefault($isDefault)
            ->setUuid($uuid);
    }
    /**
     * Get dirn value
     * @return string|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \StructType\LVoiceMailPilot
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dirn, true), gettype($dirn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dirn) && mb_strlen($dirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LVoiceMailPilot
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($description) && mb_strlen($description) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cssName value
     * @return \StructType\XFkType|null
     */
    public function getCssName()
    {
        return $this->cssName;
    }
    /**
     * Set cssName value
     * @param \StructType\XFkType $cssName
     * @return \StructType\LVoiceMailPilot
     */
    public function setCssName(\StructType\XFkType $cssName = null)
    {
        $this->cssName = $cssName;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \StructType\LVoiceMailPilot
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isDefault, true)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LVoiceMailPilot
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
