<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRemoteDestination StructType
 * @subpackage Structs
 */
class LRemoteDestination extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The answerTooSoonTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The remoteDestinationProfileName
     * Meta information extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The ctiRemoteDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ctiRemoteDeviceName;
    /**
     * The dualModeDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $dualModeDeviceName;
    /**
     * The isMobilePhone
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta information extracted from the WSDL
     * - documentation: From 10.5 version if a user doesn't specify a value in this tag, AXL will still insert a random row in todaccess because value in todaccess is required to fetch value of owner user id properly in get handler
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta information extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mobilityProfileName;
    /**
     * The singleNumberReachVoicemail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleNumberReachVoicemail;
    /**
     * The dialViaOfficeReverseVoicemail
     * Meta information extracted from the WSDL
     * - documentation: This tag is for Mobility Identity
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialViaOfficeReverseVoicemail;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRemoteDestination
     * @uses LRemoteDestination::setName()
     * @uses LRemoteDestination::setDestination()
     * @uses LRemoteDestination::setAnswerTooSoonTimer()
     * @uses LRemoteDestination::setAnswerTooLateTimer()
     * @uses LRemoteDestination::setDelayBeforeRingingCell()
     * @uses LRemoteDestination::setRemoteDestinationProfileName()
     * @uses LRemoteDestination::setCtiRemoteDeviceName()
     * @uses LRemoteDestination::setDualModeDeviceName()
     * @uses LRemoteDestination::setIsMobilePhone()
     * @uses LRemoteDestination::setEnableMobileConnect()
     * @uses LRemoteDestination::setTimeZone()
     * @uses LRemoteDestination::setTodAccessName()
     * @uses LRemoteDestination::setMobileSmartClientName()
     * @uses LRemoteDestination::setMobilityProfileName()
     * @uses LRemoteDestination::setSingleNumberReachVoicemail()
     * @uses LRemoteDestination::setDialViaOfficeReverseVoicemail()
     * @uses LRemoteDestination::setUuid()
     * @param string $name
     * @param string $destination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param \StructType\XFkType $remoteDestinationProfileName
     * @param \StructType\XFkType $ctiRemoteDeviceName
     * @param \StructType\XFkType $dualModeDeviceName
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param string $timeZone
     * @param \StructType\XFkType $todAccessName
     * @param \StructType\XFkType $mobileSmartClientName
     * @param \StructType\XFkType $mobilityProfileName
     * @param string $singleNumberReachVoicemail
     * @param string $dialViaOfficeReverseVoicemail
     * @param string $uuid
     */
    public function __construct($name = null, $destination = null, $answerTooSoonTimer = null, $answerTooLateTimer = null, $delayBeforeRingingCell = null, \StructType\XFkType $remoteDestinationProfileName = null, \StructType\XFkType $ctiRemoteDeviceName = null, \StructType\XFkType $dualModeDeviceName = null, $isMobilePhone = null, $enableMobileConnect = null, $timeZone = null, \StructType\XFkType $todAccessName = null, \StructType\XFkType $mobileSmartClientName = null, \StructType\XFkType $mobilityProfileName = null, $singleNumberReachVoicemail = null, $dialViaOfficeReverseVoicemail = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDestination($destination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName)
            ->setSingleNumberReachVoicemail($singleNumberReachVoicemail)
            ->setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LRemoteDestination
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\LRemoteDestination
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string|null
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return \StructType\LRemoteDestination
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($answerTooSoonTimer) ? implode(', ', $answerTooSoonTimer) : var_export($answerTooSoonTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string|null
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return \StructType\LRemoteDestination
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($answerTooLateTimer) ? implode(', ', $answerTooLateTimer) : var_export($answerTooLateTimer, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string|null
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return \StructType\LRemoteDestination
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($delayBeforeRingingCell) ? implode(', ', $delayBeforeRingingCell) : var_export($delayBeforeRingingCell, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * @return \StructType\XFkType|null
     */
    public function getRemoteDestinationProfileName()
    {
        return $this->remoteDestinationProfileName;
    }
    /**
     * Set remoteDestinationProfileName value
     * @param \StructType\XFkType $remoteDestinationProfileName
     * @return \StructType\LRemoteDestination
     */
    public function setRemoteDestinationProfileName(\StructType\XFkType $remoteDestinationProfileName = null)
    {
        $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * @return \StructType\XFkType|null
     */
    public function getCtiRemoteDeviceName()
    {
        return $this->ctiRemoteDeviceName;
    }
    /**
     * Set ctiRemoteDeviceName value
     * @param \StructType\XFkType $ctiRemoteDeviceName
     * @return \StructType\LRemoteDestination
     */
    public function setCtiRemoteDeviceName(\StructType\XFkType $ctiRemoteDeviceName = null)
    {
        $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * @return \StructType\XFkType|null
     */
    public function getDualModeDeviceName()
    {
        return $this->dualModeDeviceName;
    }
    /**
     * Set dualModeDeviceName value
     * @param \StructType\XFkType $dualModeDeviceName
     * @return \StructType\LRemoteDestination
     */
    public function setDualModeDeviceName(\StructType\XFkType $dualModeDeviceName = null)
    {
        $this->dualModeDeviceName = $dualModeDeviceName;
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return \StructType\LRemoteDestination
     */
    public function setIsMobilePhone($isMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isMobilePhone, true), gettype($isMobilePhone)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isMobilePhone, true)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return \StructType\LRemoteDestination
     */
    public function setEnableMobileConnect($enableMobileConnect = null)
    {
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enableMobileConnect, true), gettype($enableMobileConnect)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enableMobileConnect, true)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \EnumType\XTimeZone::valueIsValid()
     * @uses \EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \StructType\LRemoteDestination
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTimeZone', is_array($timeZone) ? implode(', ', $timeZone) : var_export($timeZone, true), implode(', ', \EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * @return \StructType\XFkType|null
     */
    public function getTodAccessName()
    {
        return $this->todAccessName;
    }
    /**
     * Set todAccessName value
     * @param \StructType\XFkType $todAccessName
     * @return \StructType\LRemoteDestination
     */
    public function setTodAccessName(\StructType\XFkType $todAccessName = null)
    {
        $this->todAccessName = $todAccessName;
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * @return \StructType\XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return $this->mobileSmartClientName;
    }
    /**
     * Set mobileSmartClientName value
     * @param \StructType\XFkType $mobileSmartClientName
     * @return \StructType\LRemoteDestination
     */
    public function setMobileSmartClientName(\StructType\XFkType $mobileSmartClientName = null)
    {
        $this->mobileSmartClientName = $mobileSmartClientName;
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * @return \StructType\XFkType|null
     */
    public function getMobilityProfileName()
    {
        return $this->mobilityProfileName;
    }
    /**
     * Set mobilityProfileName value
     * @param \StructType\XFkType $mobilityProfileName
     * @return \StructType\LRemoteDestination
     */
    public function setMobilityProfileName(\StructType\XFkType $mobilityProfileName = null)
    {
        $this->mobilityProfileName = $mobilityProfileName;
        return $this;
    }
    /**
     * Get singleNumberReachVoicemail value
     * @return string|null
     */
    public function getSingleNumberReachVoicemail()
    {
        return $this->singleNumberReachVoicemail;
    }
    /**
     * Set singleNumberReachVoicemail value
     * @uses \EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleNumberReachVoicemail
     * @return \StructType\LRemoteDestination
     */
    public function setSingleNumberReachVoicemail($singleNumberReachVoicemail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVMAvoidancePolicy::valueIsValid($singleNumberReachVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XVMAvoidancePolicy', is_array($singleNumberReachVoicemail) ? implode(', ', $singleNumberReachVoicemail) : var_export($singleNumberReachVoicemail, true), implode(', ', \EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->singleNumberReachVoicemail = $singleNumberReachVoicemail;
        return $this;
    }
    /**
     * Get dialViaOfficeReverseVoicemail value
     * @return string|null
     */
    public function getDialViaOfficeReverseVoicemail()
    {
        return $this->dialViaOfficeReverseVoicemail;
    }
    /**
     * Set dialViaOfficeReverseVoicemail value
     * @uses \EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialViaOfficeReverseVoicemail
     * @return \StructType\LRemoteDestination
     */
    public function setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVMAvoidancePolicy::valueIsValid($dialViaOfficeReverseVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XVMAvoidancePolicy', is_array($dialViaOfficeReverseVoicemail) ? implode(', ', $dialViaOfficeReverseVoicemail) : var_export($dialViaOfficeReverseVoicemail, true), implode(', ', \EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->dialViaOfficeReverseVoicemail = $dialViaOfficeReverseVoicemail;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRemoteDestination
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
