<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRemoteClusterMember StructType
 * @subpackage Structs
 */
class LRemoteClusterMember extends AbstractStructBase
{
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The remoteIpAddress1
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteIpAddress1;
    /**
     * The remoteIpAddress2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteIpAddress2;
    /**
     * The remoteIpAddress3
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remoteIpAddress3;
    /**
     * Constructor method for LRemoteClusterMember
     * @uses LRemoteClusterMember::setEnabled()
     * @uses LRemoteClusterMember::setRemoteIpAddress1()
     * @uses LRemoteClusterMember::setRemoteIpAddress2()
     * @uses LRemoteClusterMember::setRemoteIpAddress3()
     * @param string $enabled
     * @param string $remoteIpAddress1
     * @param string $remoteIpAddress2
     * @param string $remoteIpAddress3
     */
    public function __construct($enabled = null, $remoteIpAddress1 = null, $remoteIpAddress2 = null, $remoteIpAddress3 = null)
    {
        $this
            ->setEnabled($enabled)
            ->setRemoteIpAddress1($remoteIpAddress1)
            ->setRemoteIpAddress2($remoteIpAddress2)
            ->setRemoteIpAddress3($remoteIpAddress3);
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \StructType\LRemoteClusterMember
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: string
        if (!is_null($enabled) && !is_string($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($enabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($enabled, true)), __LINE__);
        }
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get remoteIpAddress1 value
     * @return string|null
     */
    public function getRemoteIpAddress1()
    {
        return $this->remoteIpAddress1;
    }
    /**
     * Set remoteIpAddress1 value
     * @param string $remoteIpAddress1
     * @return \StructType\LRemoteClusterMember
     */
    public function setRemoteIpAddress1($remoteIpAddress1 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteIpAddress1) && !is_string($remoteIpAddress1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteIpAddress1, true), gettype($remoteIpAddress1)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($remoteIpAddress1) && mb_strlen($remoteIpAddress1) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($remoteIpAddress1)), __LINE__);
        }
        $this->remoteIpAddress1 = $remoteIpAddress1;
        return $this;
    }
    /**
     * Get remoteIpAddress2 value
     * @return string|null
     */
    public function getRemoteIpAddress2()
    {
        return $this->remoteIpAddress2;
    }
    /**
     * Set remoteIpAddress2 value
     * @param string $remoteIpAddress2
     * @return \StructType\LRemoteClusterMember
     */
    public function setRemoteIpAddress2($remoteIpAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteIpAddress2) && !is_string($remoteIpAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteIpAddress2, true), gettype($remoteIpAddress2)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($remoteIpAddress2) && mb_strlen($remoteIpAddress2) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($remoteIpAddress2)), __LINE__);
        }
        $this->remoteIpAddress2 = $remoteIpAddress2;
        return $this;
    }
    /**
     * Get remoteIpAddress3 value
     * @return string|null
     */
    public function getRemoteIpAddress3()
    {
        return $this->remoteIpAddress3;
    }
    /**
     * Set remoteIpAddress3 value
     * @param string $remoteIpAddress3
     * @return \StructType\LRemoteClusterMember
     */
    public function setRemoteIpAddress3($remoteIpAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($remoteIpAddress3) && !is_string($remoteIpAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remoteIpAddress3, true), gettype($remoteIpAddress3)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($remoteIpAddress3) && mb_strlen($remoteIpAddress3) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($remoteIpAddress3)), __LINE__);
        }
        $this->remoteIpAddress3 = $remoteIpAddress3;
        return $this;
    }
}
