<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LRemoteCluster StructType
 * @subpackage Structs
 */
class LRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clusterId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fullyQualifiedName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The emcc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LRemoteClusterMember
     */
    public $uds;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LRemoteCluster
     * @uses LRemoteCluster::setClusterId()
     * @uses LRemoteCluster::setDescription()
     * @uses LRemoteCluster::setFullyQualifiedName()
     * @uses LRemoteCluster::setEmcc()
     * @uses LRemoteCluster::setPstnAccess()
     * @uses LRemoteCluster::setRsvpAgent()
     * @uses LRemoteCluster::setTftp()
     * @uses LRemoteCluster::setLbm()
     * @uses LRemoteCluster::setUds()
     * @uses LRemoteCluster::setUuid()
     * @param string $clusterId
     * @param string $description
     * @param string $fullyQualifiedName
     * @param \StructType\LRemoteClusterMember $emcc
     * @param \StructType\LRemoteClusterMember $pstnAccess
     * @param \StructType\LRemoteClusterMember $rsvpAgent
     * @param \StructType\LRemoteClusterMember $tftp
     * @param \StructType\LRemoteClusterMember $lbm
     * @param \StructType\LRemoteClusterMember $uds
     * @param string $uuid
     */
    public function __construct($clusterId = null, $description = null, $fullyQualifiedName = null, \StructType\LRemoteClusterMember $emcc = null, \StructType\LRemoteClusterMember $pstnAccess = null, \StructType\LRemoteClusterMember $rsvpAgent = null, \StructType\LRemoteClusterMember $tftp = null, \StructType\LRemoteClusterMember $lbm = null, \StructType\LRemoteClusterMember $uds = null, $uuid = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setDescription($description)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds)
            ->setUuid($uuid);
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\LRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clusterId, true), gettype($clusterId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($clusterId) && mb_strlen($clusterId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string|null
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return \StructType\LRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullyQualifiedName, true), gettype($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($fullyQualifiedName) && mb_strlen($fullyQualifiedName) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\LRemoteClusterMember $emcc
     * @return \StructType\LRemoteCluster
     */
    public function setEmcc(\StructType\LRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\LRemoteClusterMember $pstnAccess
     * @return \StructType\LRemoteCluster
     */
    public function setPstnAccess(\StructType\LRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\LRemoteClusterMember $rsvpAgent
     * @return \StructType\LRemoteCluster
     */
    public function setRsvpAgent(\StructType\LRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\LRemoteClusterMember $tftp
     * @return \StructType\LRemoteCluster
     */
    public function setTftp(\StructType\LRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\LRemoteClusterMember $lbm
     * @return \StructType\LRemoteCluster
     */
    public function setLbm(\StructType\LRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\LRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\LRemoteClusterMember $uds
     * @return \StructType\LRemoteCluster
     */
    public function setUds(\StructType\LRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LRemoteCluster
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
