<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LParameterMember StructType
 * @subpackage Structs
 */
class LParameterMember extends AbstractStructBase
{
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameter;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * The selectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for LParameterMember
     * @uses LParameterMember::setParameter()
     * @uses LParameterMember::setValue()
     * @uses LParameterMember::setSelectionOrder()
     * @param string $parameter
     * @param string $value
     * @param string $selectionOrder
     */
    public function __construct($parameter = null, $value = null, $selectionOrder = null)
    {
        $this
            ->setParameter($parameter)
            ->setValue($value)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get parameter value
     * @return string|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @uses \EnumType\XDialParameter::valueIsValid()
     * @uses \EnumType\XDialParameter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parameter
     * @return \StructType\LParameterMember
     */
    public function setParameter($parameter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDialParameter::valueIsValid($parameter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDialParameter', is_array($parameter) ? implode(', ', $parameter) : var_export($parameter, true), implode(', ', \EnumType\XDialParameter::getValidValues())), __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\LParameterMember
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string|null
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return \StructType\LParameterMember
     */
    public function setSelectionOrder($selectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($selectionOrder) ? implode(', ', $selectionOrder) : var_export($selectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
}
