<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LNormalizationScriptInfo StructType
 * @subpackage Structs
 */
class LNormalizationScriptInfo extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameterName;
    /**
     * The parameterValue
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $parameterValue;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LNormalizationScriptInfo
     * @uses LNormalizationScriptInfo::setParameterName()
     * @uses LNormalizationScriptInfo::setParameterValue()
     * @uses LNormalizationScriptInfo::setUuid()
     * @param string $parameterName
     * @param string $parameterValue
     * @param string $uuid
     */
    public function __construct($parameterName = null, $parameterValue = null, $uuid = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setParameterValue($parameterValue)
            ->setUuid($uuid);
    }
    /**
     * Get parameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \StructType\LNormalizationScriptInfo
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($parameterName) && mb_strlen($parameterName) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get parameterValue value
     * @return string|null
     */
    public function getParameterValue()
    {
        return $this->parameterValue;
    }
    /**
     * Set parameterValue value
     * @param string $parameterValue
     * @return \StructType\LNormalizationScriptInfo
     */
    public function setParameterValue($parameterValue = null)
    {
        // validation for constraint: string
        if (!is_null($parameterValue) && !is_string($parameterValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterValue, true), gettype($parameterValue)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($parameterValue) && mb_strlen($parameterValue) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($parameterValue)), __LINE__);
        }
        $this->parameterValue = $parameterValue;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LNormalizationScriptInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
