<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLineGroupMember StructType
 * @subpackage Structs
 */
class LLineGroupMember extends AbstractStructBase
{
    /**
     * The lineSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lineSelectionOrder;
    /**
     * The directoryNumber
     * Meta information extracted from the WSDL
     * - documentation: The uuid attribute is read here
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LDirn
     */
    public $directoryNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLineGroupMember
     * @uses LLineGroupMember::setLineSelectionOrder()
     * @uses LLineGroupMember::setDirectoryNumber()
     * @uses LLineGroupMember::setUuid()
     * @param string $lineSelectionOrder
     * @param \StructType\LDirn $directoryNumber
     * @param string $uuid
     */
    public function __construct($lineSelectionOrder = null, \StructType\LDirn $directoryNumber = null, $uuid = null)
    {
        $this
            ->setLineSelectionOrder($lineSelectionOrder)
            ->setDirectoryNumber($directoryNumber)
            ->setUuid($uuid);
    }
    /**
     * Get lineSelectionOrder value
     * @return string|null
     */
    public function getLineSelectionOrder()
    {
        return $this->lineSelectionOrder;
    }
    /**
     * Set lineSelectionOrder value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineSelectionOrder
     * @return \StructType\LLineGroupMember
     */
    public function setLineSelectionOrder($lineSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($lineSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($lineSelectionOrder) ? implode(', ', $lineSelectionOrder) : var_export($lineSelectionOrder, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->lineSelectionOrder = $lineSelectionOrder;
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return \StructType\LDirn|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param \StructType\LDirn $directoryNumber
     * @return \StructType\LLineGroupMember
     */
    public function setDirectoryNumber(\StructType\LDirn $directoryNumber = null)
    {
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LLineGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
