<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImeE164Transformation StructType
 * @subpackage Structs
 */
class LImeE164Transformation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The isCgpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCgpnPreTransformation;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The isCdpnPreTransformation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCdpnPreTransformation;
    /**
     * The incomingCgpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $incomingCgpnTransformationProfileName;
    /**
     * The incomingCdpnTransformationProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $incomingCdpnTransformationProfileName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImeE164Transformation
     * @uses LImeE164Transformation::setName()
     * @uses LImeE164Transformation::setDescription()
     * @uses LImeE164Transformation::setCgpnTransformationCssName()
     * @uses LImeE164Transformation::setIsCgpnPreTransformation()
     * @uses LImeE164Transformation::setCdpnTransformationCssName()
     * @uses LImeE164Transformation::setIsCdpnPreTransformation()
     * @uses LImeE164Transformation::setIncomingCgpnTransformationProfileName()
     * @uses LImeE164Transformation::setIncomingCdpnTransformationProfileName()
     * @uses LImeE164Transformation::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $isCgpnPreTransformation
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $isCdpnPreTransformation
     * @param \StructType\XFkType $incomingCgpnTransformationProfileName
     * @param \StructType\XFkType $incomingCdpnTransformationProfileName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $cgpnTransformationCssName = null, $isCgpnPreTransformation = null, \StructType\XFkType $cdpnTransformationCssName = null, $isCdpnPreTransformation = null, \StructType\XFkType $incomingCgpnTransformationProfileName = null, \StructType\XFkType $incomingCdpnTransformationProfileName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setIsCgpnPreTransformation($isCgpnPreTransformation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setIsCdpnPreTransformation($isCdpnPreTransformation)
            ->setIncomingCgpnTransformationProfileName($incomingCgpnTransformationProfileName)
            ->setIncomingCdpnTransformationProfileName($incomingCdpnTransformationProfileName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LImeE164Transformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LImeE164Transformation
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\LImeE164Transformation
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get isCgpnPreTransformation value
     * @return string|null
     */
    public function getIsCgpnPreTransformation()
    {
        return $this->isCgpnPreTransformation;
    }
    /**
     * Set isCgpnPreTransformation value
     * @param string $isCgpnPreTransformation
     * @return \StructType\LImeE164Transformation
     */
    public function setIsCgpnPreTransformation($isCgpnPreTransformation = null)
    {
        // validation for constraint: string
        if (!is_null($isCgpnPreTransformation) && !is_string($isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isCgpnPreTransformation, true), gettype($isCgpnPreTransformation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isCgpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isCgpnPreTransformation, true)), __LINE__);
        }
        $this->isCgpnPreTransformation = $isCgpnPreTransformation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\LImeE164Transformation
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get isCdpnPreTransformation value
     * @return string|null
     */
    public function getIsCdpnPreTransformation()
    {
        return $this->isCdpnPreTransformation;
    }
    /**
     * Set isCdpnPreTransformation value
     * @param string $isCdpnPreTransformation
     * @return \StructType\LImeE164Transformation
     */
    public function setIsCdpnPreTransformation($isCdpnPreTransformation = null)
    {
        // validation for constraint: string
        if (!is_null($isCdpnPreTransformation) && !is_string($isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isCdpnPreTransformation, true), gettype($isCdpnPreTransformation)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isCdpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isCdpnPreTransformation, true)), __LINE__);
        }
        $this->isCdpnPreTransformation = $isCdpnPreTransformation;
        return $this;
    }
    /**
     * Get incomingCgpnTransformationProfileName value
     * @return \StructType\XFkType|null
     */
    public function getIncomingCgpnTransformationProfileName()
    {
        return $this->incomingCgpnTransformationProfileName;
    }
    /**
     * Set incomingCgpnTransformationProfileName value
     * @param \StructType\XFkType $incomingCgpnTransformationProfileName
     * @return \StructType\LImeE164Transformation
     */
    public function setIncomingCgpnTransformationProfileName(\StructType\XFkType $incomingCgpnTransformationProfileName = null)
    {
        $this->incomingCgpnTransformationProfileName = $incomingCgpnTransformationProfileName;
        return $this;
    }
    /**
     * Get incomingCdpnTransformationProfileName value
     * @return \StructType\XFkType|null
     */
    public function getIncomingCdpnTransformationProfileName()
    {
        return $this->incomingCdpnTransformationProfileName;
    }
    /**
     * Set incomingCdpnTransformationProfileName value
     * @param \StructType\XFkType $incomingCdpnTransformationProfileName
     * @return \StructType\LImeE164Transformation
     */
    public function setIncomingCdpnTransformationProfileName(\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        $this->incomingCdpnTransformationProfileName = $incomingCdpnTransformationProfileName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LImeE164Transformation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
