<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LHuntList StructType
 * @subpackage Structs
 */
class LHuntList extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The routeListEnabled
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The voiceMailUsage
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $voiceMailUsage;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LHuntList
     * @uses LHuntList::setDescription()
     * @uses LHuntList::setCallManagerGroupName()
     * @uses LHuntList::setRouteListEnabled()
     * @uses LHuntList::setVoiceMailUsage()
     * @uses LHuntList::setName()
     * @uses LHuntList::setUuid()
     * @param string $description
     * @param \StructType\XFkType $callManagerGroupName
     * @param string $routeListEnabled
     * @param string $voiceMailUsage
     * @param string $name
     * @param string $uuid
     */
    public function __construct($description = null, \StructType\XFkType $callManagerGroupName = null, $routeListEnabled = null, $voiceMailUsage = null, $name = null, $uuid = null)
    {
        $this
            ->setDescription($description)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRouteListEnabled($routeListEnabled)
            ->setVoiceMailUsage($voiceMailUsage)
            ->setName($name)
            ->setUuid($uuid);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LHuntList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\LHuntList
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \StructType\LHuntList
     */
    public function setRouteListEnabled($routeListEnabled = null)
    {
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeListEnabled, true), gettype($routeListEnabled)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($routeListEnabled, true)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get voiceMailUsage value
     * @return string|null
     */
    public function getVoiceMailUsage()
    {
        return $this->voiceMailUsage;
    }
    /**
     * Set voiceMailUsage value
     * @param string $voiceMailUsage
     * @return \StructType\LHuntList
     */
    public function setVoiceMailUsage($voiceMailUsage = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMailUsage) && !is_string($voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voiceMailUsage, true), gettype($voiceMailUsage)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($voiceMailUsage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($voiceMailUsage, true)), __LINE__);
        }
        $this->voiceMailUsage = $voiceMailUsage;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LHuntList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LHuntList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
