<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCiscoCatalyst600024PortFXSGateway StructType
 * @subpackage Structs
 */
class LCiscoCatalyst600024PortFXSGateway extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The portSelectionOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portSelectionOrder;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCiscoCatalyst600024PortFXSGateway
     * @uses LCiscoCatalyst600024PortFXSGateway::setName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setDescription()
     * @uses LCiscoCatalyst600024PortFXSGateway::setProduct()
     * @uses LCiscoCatalyst600024PortFXSGateway::setModel()
     * @uses LCiscoCatalyst600024PortFXSGateway::setClass()
     * @uses LCiscoCatalyst600024PortFXSGateway::setProtocol()
     * @uses LCiscoCatalyst600024PortFXSGateway::setProtocolSide()
     * @uses LCiscoCatalyst600024PortFXSGateway::setCallingSearchSpaceName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setDevicePoolName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setCommonDeviceConfigName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setNetworkLocale()
     * @uses LCiscoCatalyst600024PortFXSGateway::setLocationName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setMediaResourceListName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setAutomatedAlternateRoutingCssName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setAarNeighborhoodName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setLoadInformation()
     * @uses LCiscoCatalyst600024PortFXSGateway::setTraceFlag()
     * @uses LCiscoCatalyst600024PortFXSGateway::setUseTrustedRelayPoint()
     * @uses LCiscoCatalyst600024PortFXSGateway::setCgpnTransformationCssName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setUseDevicePoolCgpnTransformCss()
     * @uses LCiscoCatalyst600024PortFXSGateway::setGeoLocationName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setPortSelectionOrder()
     * @uses LCiscoCatalyst600024PortFXSGateway::setTransmitUtf8()
     * @uses LCiscoCatalyst600024PortFXSGateway::setGeoLocationFilterName()
     * @uses LCiscoCatalyst600024PortFXSGateway::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XLoadInformation $loadInformation
     * @param string $traceFlag
     * @param string $useTrustedRelayPoint
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param string $portSelectionOrder
     * @param string $transmitUtf8
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocale = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XLoadInformation $loadInformation = null, $traceFlag = null, $useTrustedRelayPoint = null, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \StructType\XFkType $geoLocationName = null, $portSelectionOrder = null, $transmitUtf8 = null, \StructType\XFkType $geoLocationFilterName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setTraceFlag($traceFlag)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setPortSelectionOrder($portSelectionOrder)
            ->setTransmitUtf8($transmitUtf8)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($description) && mb_strlen($description) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XModel', is_array($model) ? implode(', ', $model) : var_export($model, true), implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XClass', is_array($class) ? implode(', ', $class) : var_export($class, true), implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XProtocolSide', is_array($protocolSide) ? implode(', ', $protocolSide) : var_export($protocolSide, true), implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XCountry', is_array($networkLocale) ? implode(', ', $networkLocale) : var_export($networkLocale, true), implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \StructType\XLoadInformation $loadInformation
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setLoadInformation(\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceFlag, true), gettype($traceFlag)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($traceFlag, true)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XStatus', is_array($useTrustedRelayPoint) ? implode(', ', $useTrustedRelayPoint) : var_export($useTrustedRelayPoint, true), implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useDevicePoolCgpnTransformCss, true), gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get portSelectionOrder value
     * @return string|null
     */
    public function getPortSelectionOrder()
    {
        return $this->portSelectionOrder;
    }
    /**
     * Set portSelectionOrder value
     * @uses \EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portSelectionOrder
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setPortSelectionOrder($portSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkSelectionOrder::valueIsValid($portSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XTrunkSelectionOrder', is_array($portSelectionOrder) ? implode(', ', $portSelectionOrder) : var_export($portSelectionOrder, true), implode(', ', \EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->portSelectionOrder = $portSelectionOrder;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transmitUtf8, true), gettype($transmitUtf8)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($transmitUtf8, true)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\LCiscoCatalyst600024PortFXSGateway
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($uuid, true)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
