<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class LBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The directedCallParkId
     * Meta information extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - base: xsd:string
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta information extracted from the WSDL
     * - choice: directedCallParkId | directedCallParkDnAndPartition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for LBLFDirectedCallPark
     * @uses LBLFDirectedCallPark::setLabel()
     * @uses LBLFDirectedCallPark::setDirectedCallParkId()
     * @uses LBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @uses LBLFDirectedCallPark::setIndex()
     * @param string $label
     * @param string $directedCallParkId
     * @param \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @param string $index
     */
    public function __construct($label = null, $directedCallParkId = null, \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null, $index = null)
    {
        $this
            ->setLabel($label)
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition)
            ->setIndex($index);
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\LBLFDirectedCallPark
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($label) && mb_strlen($label) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get directedCallParkId value
     * @return string|null
     */
    public function getDirectedCallParkId()
    {
        return isset($this->directedCallParkId) ? $this->directedCallParkId : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectedCallParkId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectedCallParkId method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectedCallParkIdForChoiceConstraintsFromSetDirectedCallParkId($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'directedCallParkDnAndPartition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property directedCallParkId can\'t be set as the property %s is already set. Only one property must be set among these properties: directedCallParkId, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set directedCallParkId value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $directedCallParkId
     * @return \StructType\LBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directedCallParkId, true), gettype($directedCallParkId)), __LINE__);
        }
        // validation for constraint: choice(directedCallParkId, directedCallParkDnAndPartition)
        if ('' !== ($directedCallParkIdChoiceErrorMessage = self::validateDirectedCallParkIdForChoiceConstraintsFromSetDirectedCallParkId($directedCallParkId))) {
            throw new \InvalidArgumentException($directedCallParkIdChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(\{........-....-....-....-............\})
        if (!is_null($directedCallParkId) && !preg_match('/\\{........-....-....-....-............\\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \{........-....-....-....-............\}', var_export($directedCallParkId, true)), __LINE__);
        }
        if (is_null($directedCallParkId) || (is_array($directedCallParkId) && empty($directedCallParkId))) {
            unset($this->directedCallParkId);
        } else {
            $this->directedCallParkId = $directedCallParkId;
        }
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return \StructType\DirectedCallParkDnAndPartition|null
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return isset($this->directedCallParkDnAndPartition) ? $this->directedCallParkDnAndPartition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDirectedCallParkDnAndPartition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectedCallParkDnAndPartition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDirectedCallParkDnAndPartitionForChoiceConstraintsFromSetDirectedCallParkDnAndPartition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'directedCallParkId',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property directedCallParkDnAndPartition can\'t be set as the property %s is already set. Only one property must be set among these properties: directedCallParkDnAndPartition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return \StructType\LBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        // validation for constraint: choice(directedCallParkId, directedCallParkDnAndPartition)
        if ('' !== ($directedCallParkDnAndPartitionChoiceErrorMessage = self::validateDirectedCallParkDnAndPartitionForChoiceConstraintsFromSetDirectedCallParkDnAndPartition($directedCallParkDnAndPartition))) {
            throw new \InvalidArgumentException($directedCallParkDnAndPartitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($directedCallParkDnAndPartition) || (is_array($directedCallParkDnAndPartition) && empty($directedCallParkDnAndPartition))) {
            unset($this->directedCallParkDnAndPartition);
        } else {
            $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        }
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\LBLFDirectedCallPark
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
}
