<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSNMPUserReq StructType
 * @subpackage Structs
 */
class GetSNMPUserReq extends APIRequest
{
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * @var string
     */
    public $userName;
    /**
     * Constructor method for GetSNMPUserReq
     * @uses GetSNMPUserReq::setUserName()
     * @param string $userName
     */
    public function __construct($userName = null)
    {
        $this
            ->setUserName($userName);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\GetSNMPUserReq
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($userName) && mb_strlen($userName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
}
