<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExecuteSQLQueryReq StructType
 * @subpackage Structs
 */
class ExecuteSQLQueryReq extends APIRequest
{
    /**
     * The sql
     * Meta information extracted from the WSDL
     * - documentation: WARNING: SQL Large Text and BLOB columns cannot be fetched along with other columns. A Large Text or BLOB column must be selected in its own SQL query.
     * - nillable: false
     * @var string
     */
    public $sql;
    /**
     * Constructor method for ExecuteSQLQueryReq
     * @uses ExecuteSQLQueryReq::setSql()
     * @param string $sql
     */
    public function __construct($sql = null)
    {
        $this
            ->setSql($sql);
    }
    /**
     * Get sql value
     * @return string|null
     */
    public function getSql()
    {
        return $this->sql;
    }
    /**
     * Set sql value
     * @param string $sql
     * @return \StructType\ExecuteSQLQueryReq
     */
    public function setSql($sql = null)
    {
        // validation for constraint: string
        if (!is_null($sql) && !is_string($sql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sql, true), gettype($sql)), __LINE__);
        }
        $this->sql = $sql;
        return $this;
    }
}
