<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for attributeSet StructType
 * @subpackage Structs
 */
class AttributeSet extends XCommonMembersExtension
{
    /**
     * The attributeNameString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $attributeNameString;
    /**
     * The sdpAttributeHandling
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sdpAttributeHandling;
    /**
     * The allowedValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var string[]
     */
    public $allowedValue;
    /**
     * Constructor method for attributeSet
     * @uses AttributeSet::setAttributeNameString()
     * @uses AttributeSet::setSdpAttributeHandling()
     * @uses AttributeSet::setAllowedValue()
     * @param string $attributeNameString
     * @param string $sdpAttributeHandling
     * @param string[] $allowedValue
     */
    public function __construct($attributeNameString = null, $sdpAttributeHandling = null, array $allowedValue = array())
    {
        $this
            ->setAttributeNameString($attributeNameString)
            ->setSdpAttributeHandling($sdpAttributeHandling)
            ->setAllowedValue($allowedValue);
    }
    /**
     * Get attributeNameString value
     * @return string|null
     */
    public function getAttributeNameString()
    {
        return $this->attributeNameString;
    }
    /**
     * Set attributeNameString value
     * @param string $attributeNameString
     * @return \StructType\AttributeSet
     */
    public function setAttributeNameString($attributeNameString = null)
    {
        // validation for constraint: string
        if (!is_null($attributeNameString) && !is_string($attributeNameString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeNameString, true), gettype($attributeNameString)), __LINE__);
        }
        $this->attributeNameString = $attributeNameString;
        return $this;
    }
    /**
     * Get sdpAttributeHandling value
     * @return string|null
     */
    public function getSdpAttributeHandling()
    {
        return $this->sdpAttributeHandling;
    }
    /**
     * Set sdpAttributeHandling value
     * @param string $sdpAttributeHandling
     * @return \StructType\AttributeSet
     */
    public function setSdpAttributeHandling($sdpAttributeHandling = null)
    {
        // validation for constraint: string
        if (!is_null($sdpAttributeHandling) && !is_string($sdpAttributeHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sdpAttributeHandling, true), gettype($sdpAttributeHandling)), __LINE__);
        }
        $this->sdpAttributeHandling = $sdpAttributeHandling;
        return $this;
    }
    /**
     * Get allowedValue value
     * @return string[]|null
     */
    public function getAllowedValue()
    {
        return $this->allowedValue;
    }
    /**
     * This method is responsible for validating the values passed to the setAllowedValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowedValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowedValueForArrayConstraintsFromSetAllowedValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributeSetAllowedValueItem) {
            // validation for constraint: itemType
            if (!is_string($attributeSetAllowedValueItem)) {
                $invalidValues[] = is_object($attributeSetAllowedValueItem) ? get_class($attributeSetAllowedValueItem) : sprintf('%s(%s)', gettype($attributeSetAllowedValueItem), var_export($attributeSetAllowedValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The allowedValue property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set allowedValue value
     * @throws \InvalidArgumentException
     * @param string[] $allowedValue
     * @return \StructType\AttributeSet
     */
    public function setAllowedValue(array $allowedValue = array())
    {
        // validation for constraint: array
        if ('' !== ($allowedValueArrayErrorMessage = self::validateAllowedValueForArrayConstraintsFromSetAllowedValue($allowedValue))) {
            throw new \InvalidArgumentException($allowedValueArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($allowedValue) && count($allowedValue) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($allowedValue)), __LINE__);
        }
        $this->allowedValue = $allowedValue;
        return $this;
    }
    /**
     * Add item to allowedValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AttributeSet
     */
    public function addToAllowedValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The allowedValue property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->allowedValue) && count($this->allowedValue) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->allowedValue)), __LINE__);
        }
        $this->allowedValue[] = $item;
        return $this;
    }
}
