<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedDevices StructType
 * Meta information extracted from the WSDL
 * - documentation: Read only | Also known as controlled devices.
 * @subpackage Structs
 */
class AssociatedDevices extends AbstractStructBase
{
    /**
     * The device
     * Meta information extracted from the WSDL
     * - documentation: Name of device.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $device;
    /**
     * Constructor method for associatedDevices
     * @uses AssociatedDevices::setDevice()
     * @param string[] $device
     */
    public function __construct(array $device = array())
    {
        $this
            ->setDevice($device);
    }
    /**
     * Get device value
     * @return string[]|null
     */
    public function getDevice()
    {
        return $this->device;
    }
    /**
     * This method is responsible for validating the values passed to the setDevice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDevice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceForArrayConstraintsFromSetDevice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedDevicesDeviceItem) {
            // validation for constraint: itemType
            if (!is_string($associatedDevicesDeviceItem)) {
                $invalidValues[] = is_object($associatedDevicesDeviceItem) ? get_class($associatedDevicesDeviceItem) : sprintf('%s(%s)', gettype($associatedDevicesDeviceItem), var_export($associatedDevicesDeviceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The device property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setDevice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDevice method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceForMaxLengthConstraintFromSetDevice($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $associatedDevicesDeviceItem) {
            // validation for constraint: maxLength(50)
            if (mb_strlen($associatedDevicesDeviceItem) > 50) {
                $invalidValues[] = var_export($associatedDevicesDeviceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 50', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set device value
     * @throws \InvalidArgumentException
     * @param string[] $device
     * @return \StructType\AssociatedDevices
     */
    public function setDevice(array $device = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceArrayErrorMessage = self::validateDeviceForArrayConstraintsFromSetDevice($device))) {
            throw new \InvalidArgumentException($deviceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if ('' !== ($deviceMaxLengthErrorMessage = self::validateDeviceForMaxLengthConstraintFromSetDevice($device))) {
            throw new \InvalidArgumentException($deviceMaxLengthErrorMessage, __LINE__);
        }
        $this->device = $device;
        return $this;
    }
    /**
     * Add item to device value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\AssociatedDevices
     */
    public function addToDevice($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The device property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (mb_strlen($item) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($item)), __LINE__);
        }
        $this->device[] = $item;
        return $this;
    }
}
