<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for alarmConfigs StructType
 * @subpackage Structs
 */
class AlarmConfigs extends AbstractStructBase
{
    /**
     * The AlarmConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\RSyslogConfig[]
     */
    public $AlarmConfig;
    /**
     * Constructor method for alarmConfigs
     * @uses AlarmConfigs::setAlarmConfig()
     * @param \StructType\RSyslogConfig[] $alarmConfig
     */
    public function __construct(array $alarmConfig = array())
    {
        $this
            ->setAlarmConfig($alarmConfig);
    }
    /**
     * Get AlarmConfig value
     * @return \StructType\RSyslogConfig[]
     */
    public function getAlarmConfig()
    {
        return $this->AlarmConfig;
    }
    /**
     * This method is responsible for validating the values passed to the setAlarmConfig method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlarmConfig method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlarmConfigForArrayConstraintsFromSetAlarmConfig(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $alarmConfigsAlarmConfigItem) {
            // validation for constraint: itemType
            if (!$alarmConfigsAlarmConfigItem instanceof \StructType\RSyslogConfig) {
                $invalidValues[] = is_object($alarmConfigsAlarmConfigItem) ? get_class($alarmConfigsAlarmConfigItem) : sprintf('%s(%s)', gettype($alarmConfigsAlarmConfigItem), var_export($alarmConfigsAlarmConfigItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AlarmConfig property can only contain items of type \StructType\RSyslogConfig, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AlarmConfig value
     * @throws \InvalidArgumentException
     * @param \StructType\RSyslogConfig[] $alarmConfig
     * @return \StructType\AlarmConfigs
     */
    public function setAlarmConfig(array $alarmConfig = array())
    {
        // validation for constraint: array
        if ('' !== ($alarmConfigArrayErrorMessage = self::validateAlarmConfigForArrayConstraintsFromSetAlarmConfig($alarmConfig))) {
            throw new \InvalidArgumentException($alarmConfigArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($alarmConfig) && count($alarmConfig) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($alarmConfig)), __LINE__);
        }
        $this->AlarmConfig = $alarmConfig;
        return $this;
    }
    /**
     * Add item to AlarmConfig value
     * @throws \InvalidArgumentException
     * @param \StructType\RSyslogConfig $item
     * @return \StructType\AlarmConfigs
     */
    public function addToAlarmConfig(\StructType\RSyslogConfig $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RSyslogConfig) {
            throw new \InvalidArgumentException(sprintf('The AlarmConfig property can only contain items of type \StructType\RSyslogConfig, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->AlarmConfig) && count($this->AlarmConfig) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->AlarmConfig)), __LINE__);
        }
        $this->AlarmConfig[] = $item;
        return $this;
    }
}
