<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addPlars StructType
 * @subpackage Structs
 */
class AddPlars extends XCommonMembersExtension
{
    /**
     * The plar
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPatternMember[]
     */
    public $plar;
    /**
     * Constructor method for addPlars
     * @uses AddPlars::setPlar()
     * @param \StructType\XPatternMember[] $plar
     */
    public function __construct(array $plar = array())
    {
        $this
            ->setPlar($plar);
    }
    /**
     * Get plar value
     * @return \StructType\XPatternMember[]
     */
    public function getPlar()
    {
        return $this->plar;
    }
    /**
     * This method is responsible for validating the values passed to the setPlar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlar method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlarForArrayConstraintsFromSetPlar(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addPlarsPlarItem) {
            // validation for constraint: itemType
            if (!$addPlarsPlarItem instanceof \StructType\XPatternMember) {
                $invalidValues[] = is_object($addPlarsPlarItem) ? get_class($addPlarsPlarItem) : sprintf('%s(%s)', gettype($addPlarsPlarItem), var_export($addPlarsPlarItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The plar property can only contain items of type \StructType\XPatternMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set plar value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember[] $plar
     * @return \StructType\AddPlars
     */
    public function setPlar(array $plar = array())
    {
        // validation for constraint: array
        if ('' !== ($plarArrayErrorMessage = self::validatePlarForArrayConstraintsFromSetPlar($plar))) {
            throw new \InvalidArgumentException($plarArrayErrorMessage, __LINE__);
        }
        $this->plar = $plar;
        return $this;
    }
    /**
     * Add item to plar value
     * @throws \InvalidArgumentException
     * @param \StructType\XPatternMember $item
     * @return \StructType\AddPlars
     */
    public function addToPlar(\StructType\XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The plar property can only contain items of type \StructType\XPatternMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->plar[] = $item;
        return $this;
    }
}
