<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLines StructType
 * @subpackage Structs
 */
class AddLines extends AbstractStructBase
{
    /**
     * The line
     * Meta information extracted from the WSDL
     * - documentation: An XLine is an entry in the DeviceNumPlanMap table. The actual directory number is referenced inside the XLine object by the "dirn" or "dirnId" element.
     * - choice: line | lineIdentifier
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XPhoneLine[]
     */
    public $line;
    /**
     * The lineIdentifier
     * Meta information extracted from the WSDL
     * - documentation: The lineIdentifier is a shorthand method that refers to a particular directory number.
     * - choice: line | lineIdentifier
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\XNumplanIdentifier[]
     */
    public $lineIdentifier;
    /**
     * Constructor method for addLines
     * @uses AddLines::setLine()
     * @uses AddLines::setLineIdentifier()
     * @param \StructType\XPhoneLine[] $line
     * @param \StructType\XNumplanIdentifier[] $lineIdentifier
     */
    public function __construct(array $line = array(), array $lineIdentifier = array())
    {
        $this
            ->setLine($line)
            ->setLineIdentifier($lineIdentifier);
    }
    /**
     * Get line value
     * @return \StructType\XPhoneLine[]
     */
    public function getLine()
    {
        return isset($this->line) ? $this->line : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineForArrayConstraintsFromSetLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addLinesLineItem) {
            // validation for constraint: itemType
            if (!$addLinesLineItem instanceof \StructType\XPhoneLine) {
                $invalidValues[] = is_object($addLinesLineItem) ? get_class($addLinesLineItem) : sprintf('%s(%s)', gettype($addLinesLineItem), var_export($addLinesLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The line property can only contain items of type \StructType\XPhoneLine, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLine method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLineForChoiceConstraintsFromSetLine($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'lineIdentifier',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property line can\'t be set as the property %s is already set. Only one property must be set among these properties: line, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set line value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\XPhoneLine[] $line
     * @return \StructType\AddLines
     */
    public function setLine(array $line = array())
    {
        // validation for constraint: array
        if ('' !== ($lineArrayErrorMessage = self::validateLineForArrayConstraintsFromSetLine($line))) {
            throw new \InvalidArgumentException($lineArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(line, lineIdentifier)
        if ('' !== ($lineChoiceErrorMessage = self::validateLineForChoiceConstraintsFromSetLine($line))) {
            throw new \InvalidArgumentException($lineChoiceErrorMessage, __LINE__);
        }
        if (is_null($line) || (is_array($line) && empty($line))) {
            unset($this->line);
        } else {
            $this->line = $line;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToLine method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToLine($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'lineIdentifier',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property line can\'t be set as the property %s is already set. Only one property must be set among these properties: line, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to line value
     * @throws \InvalidArgumentException
     * @param \StructType\XPhoneLine $item
     * @return \StructType\AddLines
     */
    public function addToLine(\StructType\XPhoneLine $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XPhoneLine) {
            throw new \InvalidArgumentException(sprintf('The line property can only contain items of type \StructType\XPhoneLine, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(line, lineIdentifier)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToLine($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->line[] = $item;
        return $this;
    }
    /**
     * Get lineIdentifier value
     * @return \StructType\XNumplanIdentifier[]
     */
    public function getLineIdentifier()
    {
        return isset($this->lineIdentifier) ? $this->lineIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineIdentifierForArrayConstraintsFromSetLineIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addLinesLineIdentifierItem) {
            // validation for constraint: itemType
            if (!$addLinesLineIdentifierItem instanceof \StructType\XNumplanIdentifier) {
                $invalidValues[] = is_object($addLinesLineIdentifierItem) ? get_class($addLinesLineIdentifierItem) : sprintf('%s(%s)', gettype($addLinesLineIdentifierItem), var_export($addLinesLineIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lineIdentifier property can only contain items of type \StructType\XNumplanIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setLineIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineIdentifier method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLineIdentifierForChoiceConstraintsFromSetLineIdentifier($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'line',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property lineIdentifier can\'t be set as the property %s is already set. Only one property must be set among these properties: lineIdentifier, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set lineIdentifier value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\XNumplanIdentifier[] $lineIdentifier
     * @return \StructType\AddLines
     */
    public function setLineIdentifier(array $lineIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($lineIdentifierArrayErrorMessage = self::validateLineIdentifierForArrayConstraintsFromSetLineIdentifier($lineIdentifier))) {
            throw new \InvalidArgumentException($lineIdentifierArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(line, lineIdentifier)
        if ('' !== ($lineIdentifierChoiceErrorMessage = self::validateLineIdentifierForChoiceConstraintsFromSetLineIdentifier($lineIdentifier))) {
            throw new \InvalidArgumentException($lineIdentifierChoiceErrorMessage, __LINE__);
        }
        if (is_null($lineIdentifier) || (is_array($lineIdentifier) && empty($lineIdentifier))) {
            unset($this->lineIdentifier);
        } else {
            $this->lineIdentifier = $lineIdentifier;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToLineIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToLineIdentifier method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToLineIdentifier($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'line',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property lineIdentifier can\'t be set as the property %s is already set. Only one property must be set among these properties: lineIdentifier, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to lineIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\XNumplanIdentifier $item
     * @return \StructType\AddLines
     */
    public function addToLineIdentifier(\StructType\XNumplanIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XNumplanIdentifier) {
            throw new \InvalidArgumentException(sprintf('The lineIdentifier property can only contain items of type \StructType\XNumplanIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(line, lineIdentifier)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToLineIdentifier($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->lineIdentifier[] = $item;
        return $this;
    }
}
