<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipProfile(\StructType\UpdateSipProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipTrunkSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipTrunkSecurityProfile(\StructType\UpdateSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTimePeriodReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTimePeriod(\StructType\UpdateTimePeriodReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTimeScheduleReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTimeSchedule(\StructType\UpdateTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTodAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTodAccess(\StructType\UpdateTodAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVoiceMailPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVoiceMailPilot(\StructType\UpdateVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProcessNodeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateProcessNode(\StructType\UpdateProcessNodeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallerFilterListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallerFilterList(\StructType\UpdateCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRoutePartitionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRoutePartition(\StructType\UpdateRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCssReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCss(\StructType\UpdateCssReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallManagerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallManager(\StructType\UpdateCallManagerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMediaResourceGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMediaResourceGroup(\StructType\UpdateMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMediaResourceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMediaResourceList(\StructType\UpdateMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRegionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRegion(\StructType\UpdateRegionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAarGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAarGroup(\StructType\UpdateAarGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePhysicalLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePhysicalLocation(\StructType\UpdatePhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRouteGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRouteGroup(\StructType\UpdateRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDevicePoolReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDevicePool(\StructType\UpdateDevicePoolReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeviceMobilityGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDeviceMobilityGroup(\StructType\UpdateDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLocation(\StructType\UpdateLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSoftKeyTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSoftKeyTemplate(\StructType\UpdateSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTranscoderReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTranscoder(\StructType\UpdateTranscoderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCommonDeviceConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCommonDeviceConfig(\StructType\UpdateCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateResourcePriorityNamespaceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespace(\StructType\UpdateResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateResourcePriorityNamespaceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateResourcePriorityNamespaceList(\StructType\UpdateResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeviceMobilityReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDeviceMobility(\StructType\UpdateDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCmcInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCmcInfo(\StructType\UpdateCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCredentialPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCredentialPolicy(\StructType\UpdateCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFacInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFacInfo(\StructType\UpdateFacInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateHuntListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateHuntList(\StructType\UpdateHuntListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateIvrUserLocaleReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateIvrUserLocale(\StructType\UpdateIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLineGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLineGroup(\StructType\UpdateLineGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRecordingProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRecordingProfile(\StructType\UpdateRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRouteFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRouteFilter(\StructType\UpdateRouteFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallManagerGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallManagerGroup(\StructType\UpdateCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUserGroup(\StructType\UpdateUserGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateProcessNodeServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateProcessNodeService(\StructType\UpdateProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMohAudioSourceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMohAudioSource(\StructType\UpdateMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDhcpServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDhcpServer(\StructType\UpdateDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDhcpSubnetReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDhcpSubnet(\StructType\UpdateDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallPark(\StructType\UpdateCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDirectedCallParkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDirectedCallPark(\StructType\UpdateDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMeetMeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMeetMe(\StructType\UpdateMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMobileVoiceAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMobileVoiceAccess(\StructType\UpdateMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRouteListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRouteList(\StructType\UpdateRouteListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUser(\StructType\UpdateUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAppUserReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAppUser(\StructType\UpdateAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipRealmReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipRealm(\StructType\UpdateSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePhoneNtpReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePhoneNtp(\StructType\UpdatePhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDateTimeGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDateTimeGroup(\StructType\UpdateDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePresenceGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePresenceGroup(\StructType\UpdatePresenceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGeoLocationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGeoLocation(\StructType\UpdateGeoLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSrstReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSrst(\StructType\UpdateSrstReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMlppDomainReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMlppDomain(\StructType\UpdateMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCumaServerSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCumaServerSecurityProfile(\StructType\UpdateCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateApplicationServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateApplicationServer(\StructType\UpdateApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateApplicationUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateApplicationUserCapfProfile(\StructType\UpdateApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEndUserCapfProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateEndUserCapfProfile(\StructType\UpdateEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateServiceParameterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateServiceParameter(\StructType\UpdateServiceParameterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGeoLocationFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGeoLocationFilter(\StructType\UpdateGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVoiceMailProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVoiceMailProfile(\StructType\UpdateVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVoiceMailPortReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVoiceMailPort(\StructType\UpdateVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatekeeperReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatekeeper(\StructType\UpdateGatekeeperReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePhoneButtonTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePhoneButtonTemplate(\StructType\UpdatePhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCommonPhoneConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCommonPhoneConfig(\StructType\UpdateCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMessageWaitingReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMessageWaiting(\StructType\UpdateMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateIpPhoneServicesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateIpPhoneServices(\StructType\UpdateIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCtiRoutePointReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCtiRoutePoint(\StructType\UpdateCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTransPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTransPattern(\StructType\UpdateTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallingPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallingPartyTransformationPattern(\StructType\UpdateCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipRoutePattern(\StructType\UpdateSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateHuntPilotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateHuntPilot(\StructType\UpdateHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRoutePatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRoutePattern(\StructType\UpdateRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateApplicationDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateApplicationDialRules(\StructType\UpdateApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDirectoryLookupDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDirectoryLookupDialRules(\StructType\UpdateDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePhoneSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePhoneSecurityProfile(\StructType\UpdatePhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipDialRulesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipDialRules(\StructType\UpdateSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateConferenceBridgeReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateConferenceBridge(\StructType\UpdateConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAnnunciatorReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAnnunciator(\StructType\UpdateAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMtpReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMtp(\StructType\UpdateMtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFixedMohAudioSourceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFixedMohAudioSource(\StructType\UpdateFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAarGroupMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAarGroupMatrixReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAarGroupMatrix(\StructType\UpdateAarGroupMatrixReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAarGroupMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRemoteDestinationProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRemoteDestinationProfile(\StructType\UpdateRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLineReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLine(\StructType\UpdateLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDefaultDeviceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDefaultDeviceProfile(\StructType\UpdateDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateH323PhoneReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateH323Phone(\StructType\UpdateH323PhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMohServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMohServer(\StructType\UpdateMohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateH323TrunkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateH323Trunk(\StructType\UpdateH323TrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePhoneReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePhone(\StructType\UpdatePhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateH323GatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateH323Gateway(\StructType\UpdateH323GatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDeviceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDeviceProfile(\StructType\UpdateDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRemoteDestinationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRemoteDestination(\StructType\UpdateRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVg224Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVg224(\StructType\UpdateVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGateway(\StructType\UpdateGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointAnalogAccess(\StructType\UpdateGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessPri(\StructType\UpdateGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessBri(\StructType\UpdateGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatewayEndpointDigitalAccessT1(\StructType\UpdateGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst600024PortFXSGateway(\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000E1VoIPGateway(\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayPri(\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCiscoCatalyst6000T1VoIPGatewayT1(\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCallPickupGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCallPickupGroup(\StructType\UpdateCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGeoLocationPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGeoLocationPolicy(\StructType\UpdateGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSipTrunkReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSipTrunk(\StructType\UpdateSipTrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRegionMatrix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRegionMatrixReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRegionMatrix(\StructType\UpdateRegionMatrixReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRegionMatrix($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCalledPartyTransformationPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCalledPartyTransformationPattern(\StructType\UpdateCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateExternalCallControlProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateExternalCallControlProfile(\StructType\UpdateExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSafSecurityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSafSecurityProfile(\StructType\UpdateSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSafForwarderReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSafForwarder(\StructType\UpdateSafForwarderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCcdHostedDNReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCcdHostedDN(\StructType\UpdateCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCcdHostedDNGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCcdHostedDNGroup(\StructType\UpdateCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCcdRequestingServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCcdRequestingService(\StructType\UpdateCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInterClusterServiceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateInterClusterServiceProfile(\StructType\UpdateInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRemoteClusterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRemoteCluster(\StructType\UpdateRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCcdAdvertisingServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCcdAdvertisingService(\StructType\UpdateCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLdapDirectoryReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLdapDirectory(\StructType\UpdateLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEmccFeatureConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateEmccFeatureConfig(\StructType\UpdateEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSafCcdPurgeBlockLearnedRoutes(\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVpnGatewayReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVpnGateway(\StructType\UpdateVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVpnGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVpnGroup(\StructType\UpdateVpnGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVpnProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVpnProfile(\StructType\UpdateVpnProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeServer(\StructType\UpdateImeServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeRouteFilterGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterGroup(\StructType\UpdateImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeRouteFilterElementReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeRouteFilterElement(\StructType\UpdateImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeClientReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeClient(\StructType\UpdateImeClientReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeEnrolledPatternReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPattern(\StructType\UpdateImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeEnrolledPatternGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeEnrolledPatternGroup(\StructType\UpdateImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeExclusionNumberReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumber(\StructType\UpdateImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeExclusionNumberGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeExclusionNumberGroup(\StructType\UpdateImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeFirewallReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeFirewall(\StructType\UpdateImeFirewallReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeE164TransformationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeE164Transformation(\StructType\UpdateImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTransformationProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTransformationProfile(\StructType\UpdateTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFallbackProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFallbackProfile(\StructType\UpdateFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLdapFilterReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLdapFilter(\StructType\UpdateLdapFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAppServerInfoReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAppServerInfo(\StructType\UpdateAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTvsCertificateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateTvsCertificate(\StructType\UpdateTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFeatureControlPolicyReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFeatureControlPolicy(\StructType\UpdateFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMobilityProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMobilityProfile(\StructType\UpdateMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateEnterpriseFeatureAccessConfiguration(\StructType\UpdateEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateHandoffConfigurationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateHandoffConfiguration(\StructType\UpdateHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSIPNormalizationScriptReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSIPNormalizationScript(\StructType\UpdateSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomUserFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCustomUserField(\StructType\UpdateCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGatewaySccpEndpointsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateGatewaySccpEndpoints(\StructType\UpdateGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLbmGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLbmGroup(\StructType\UpdateLbmGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAnnouncementReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAnnouncement(\StructType\UpdateAnnouncementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateServiceProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateServiceProfile(\StructType\UpdateServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLdapSyncCustomFieldReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLdapSyncCustomField(\StructType\UpdateLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAudioCodecPreferenceListReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAudioCodecPreferenceList(\StructType\UpdateAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUcServiceReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUcService(\StructType\UpdateUcServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLbmHubGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLbmHubGroup(\StructType\UpdateLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImportedDirectoryUriCatalogsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImportedDirectoryUriCatalogs(\StructType\UpdateImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateVohServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateVohServer(\StructType\UpdateVohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSdpTransparencyProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSdpTransparencyProfile(\StructType\UpdateSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFeatureGroupTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFeatureGroupTemplate(\StructType\UpdateFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateDirNumberAliasLookupandSyncReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateDirNumberAliasLookupandSync(\StructType\UpdateDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateAdvertisedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateAdvertisedPatterns(\StructType\UpdateAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateBlockedLearnedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateBlockedLearnedPatterns(\StructType\UpdateBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCCAProfilesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCCAProfiles(\StructType\UpdateCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUniversalDeviceTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUniversalDeviceTemplate(\StructType\UpdateUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserProfileProvisionReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUserProfileProvision(\StructType\UpdateUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePresenceRedundancyGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePresenceRedundancyGroup(\StructType\UpdatePresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateWifiHotspotReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateWifiHotspot(\StructType\UpdateWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateWlanProfileGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateWlanProfileGroup(\StructType\UpdateWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateWLANProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateWLANProfile(\StructType\UpdateWLANProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUniversalLineTemplateReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateUniversalLineTemplate(\StructType\UpdateUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateNetworkAccessProfileReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateNetworkAccessProfile(\StructType\UpdateNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateMobilityReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateMobility(\StructType\UpdateMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEnterprisePhoneConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateEnterprisePhoneConfig(\StructType\UpdateEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLdapSystemReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLdapSystem(\StructType\UpdateLdapSystemReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLdapAuthenticationReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLdapAuthentication(\StructType\UpdateLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeFeatureConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeFeatureConfig(\StructType\UpdateImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateFallbackFeatureConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateFallbackFeatureConfig(\StructType\UpdateFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateImeLearnedRoutesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateImeLearnedRoutes(\StructType\UpdateImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSoftKeySetReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSoftKeySet(\StructType\UpdateSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSyslogConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSyslogConfigurationReq $axlParams
     * @return \StructType\UpdateSyslogConfigurationRes|bool
     */
    public function updateSyslogConfiguration(\StructType\UpdateSyslogConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSyslogConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateInterClusterDirectoryUri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInterClusterDirectoryUriReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateInterClusterDirectoryUri(\StructType\UpdateInterClusterDirectoryUriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateInterClusterDirectoryUri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateIlsConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateIlsConfigReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateIlsConfig(\StructType\UpdateIlsConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateIlsConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSNMPCommunityStringReq $axlParams
     * @return \StructType\UpdateSNMPCommunityStringRes|bool
     */
    public function updateSNMPCommunityString(\StructType\UpdateSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSNMPUserReq $axlParams
     * @return \StructType\UpdateSNMPUserRes|bool
     */
    public function updateSNMPUser(\StructType\UpdateSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSNMPMIB2List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSNMPMIB2ListReq $axlParams
     * @return \StructType\UpdateSNMPMIB2ListRes|bool
     */
    public function updateSNMPMIB2List(\StructType\UpdateSNMPMIB2ListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSNMPMIB2List($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateBillingServerReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateBillingServer(\StructType\UpdateBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCcdFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCcdFeatureConfigReq $axlParams
     * @return \StructType\UpdateCcdFeatureConfigRes|bool
     */
    public function updateCcdFeatureConfig(\StructType\UpdateCcdFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCcdFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * updateRoutePartitionsForLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateRoutePartitionsForLearnedPatternsReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateRoutePartitionsForLearnedPatterns(\StructType\UpdateRoutePartitionsForLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateRoutePartitionsForLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLocalRouteGroupReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateLocalRouteGroup(\StructType\UpdateLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePageLayoutPreferences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePageLayoutPreferencesReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updatePageLayoutPreferences(\StructType\UpdatePageLayoutPreferencesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePageLayoutPreferences($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCredentialPolicyDefault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCredentialPolicyDefaultReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateCredentialPolicyDefault(\StructType\UpdateCredentialPolicyDefaultReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCredentialPolicyDefault($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSelfProvisioning
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSelfProvisioningReq $axlParams
     * @return \StructType\StandardResponse|bool
     */
    public function updateSelfProvisioning(\StructType\UpdateSelfProvisioningReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->updateSelfProvisioning($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StandardResponse|\StructType\UpdateCcdFeatureConfigRes|\StructType\UpdateSNMPCommunityStringRes|\StructType\UpdateSNMPMIB2ListRes|\StructType\UpdateSNMPUserRes|\StructType\UpdateSyslogConfigurationRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
