<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSipProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipProfileReq $axlParams
     * @return \StructType\GetSipProfileRes|bool
     */
    public function getSipProfile(\StructType\GetSipProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipProfileOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipProfileOptionsReq $axlParams
     * @return \StructType\GetSipProfileOptionsRes|bool
     */
    public function getSipProfileOptions(\StructType\GetSipProfileOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipProfileOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunkSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipTrunkSecurityProfileReq $axlParams
     * @return \StructType\GetSipTrunkSecurityProfileRes|bool
     */
    public function getSipTrunkSecurityProfile(\StructType\GetSipTrunkSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipTrunkSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimePeriodReq $axlParams
     * @return \StructType\GetTimePeriodRes|bool
     */
    public function getTimePeriod(\StructType\GetTimePeriodReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTimePeriod($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTimeSchedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimeScheduleReq $axlParams
     * @return \StructType\GetTimeScheduleRes|bool
     */
    public function getTimeSchedule(\StructType\GetTimeScheduleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTimeSchedule($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTodAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTodAccessReq $axlParams
     * @return \StructType\GetTodAccessRes|bool
     */
    public function getTodAccess(\StructType\GetTodAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTodAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoiceMailPilotReq $axlParams
     * @return \StructType\GetVoiceMailPilotRes|bool
     */
    public function getVoiceMailPilot(\StructType\GetVoiceMailPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProcessNodeReq $axlParams
     * @return \StructType\GetProcessNodeRes|bool
     */
    public function getProcessNode(\StructType\GetProcessNodeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getProcessNode($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallerFilterList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallerFilterListReq $axlParams
     * @return \StructType\GetCallerFilterListRes|bool
     */
    public function getCallerFilterList(\StructType\GetCallerFilterListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallerFilterList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePartition
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRoutePartitionReq $axlParams
     * @return \StructType\GetRoutePartitionRes|bool
     */
    public function getRoutePartition(\StructType\GetRoutePartitionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRoutePartition($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCss
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCssReq $axlParams
     * @return \StructType\GetCssRes|bool
     */
    public function getCss(\StructType\GetCssReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCss($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallManagerReq $axlParams
     * @return \StructType\GetCallManagerRes|bool
     */
    public function getCallManager(\StructType\GetCallManagerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallManager($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaResourceGroupReq $axlParams
     * @return \StructType\GetMediaResourceGroupRes|bool
     */
    public function getMediaResourceGroup(\StructType\GetMediaResourceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaResourceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMediaResourceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMediaResourceListReq $axlParams
     * @return \StructType\GetMediaResourceListRes|bool
     */
    public function getMediaResourceList(\StructType\GetMediaResourceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMediaResourceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRegion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegionReq $axlParams
     * @return \StructType\GetRegionRes|bool
     */
    public function getRegion(\StructType\GetRegionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRegion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAarGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAarGroupReq $axlParams
     * @return \StructType\GetAarGroupRes|bool
     */
    public function getAarGroup(\StructType\GetAarGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAarGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhysicalLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhysicalLocationReq $axlParams
     * @return \StructType\GetPhysicalLocationRes|bool
     */
    public function getPhysicalLocation(\StructType\GetPhysicalLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhysicalLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteGroupReq $axlParams
     * @return \StructType\GetRouteGroupRes|bool
     */
    public function getRouteGroup(\StructType\GetRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDevicePool
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDevicePoolReq $axlParams
     * @return \StructType\GetDevicePoolRes|bool
     */
    public function getDevicePool(\StructType\GetDevicePoolReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDevicePool($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobilityGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceMobilityGroupReq $axlParams
     * @return \StructType\GetDeviceMobilityGroupRes|bool
     */
    public function getDeviceMobilityGroup(\StructType\GetDeviceMobilityGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceMobilityGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocationReq $axlParams
     * @return \StructType\GetLocationRes|bool
     */
    public function getLocation(\StructType\GetLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeyTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSoftKeyTemplateReq $axlParams
     * @return \StructType\GetSoftKeyTemplateRes|bool
     */
    public function getSoftKeyTemplate(\StructType\GetSoftKeyTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSoftKeyTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTranscoder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTranscoderReq $axlParams
     * @return \StructType\GetTranscoderRes|bool
     */
    public function getTranscoder(\StructType\GetTranscoderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTranscoder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonDeviceConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommonDeviceConfigReq $axlParams
     * @return \StructType\GetCommonDeviceConfigRes|bool
     */
    public function getCommonDeviceConfig(\StructType\GetCommonDeviceConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCommonDeviceConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResourcePriorityNamespaceReq $axlParams
     * @return \StructType\GetResourcePriorityNamespaceRes|bool
     */
    public function getResourcePriorityNamespace(\StructType\GetResourcePriorityNamespaceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getResourcePriorityNamespace($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getResourcePriorityNamespaceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetResourcePriorityNamespaceListReq $axlParams
     * @return \StructType\GetResourcePriorityNamespaceListRes|bool
     */
    public function getResourcePriorityNamespaceList(\StructType\GetResourcePriorityNamespaceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getResourcePriorityNamespaceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceMobilityReq $axlParams
     * @return \StructType\GetDeviceMobilityRes|bool
     */
    public function getDeviceMobility(\StructType\GetDeviceMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCmcInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCmcInfoReq $axlParams
     * @return \StructType\GetCmcInfoRes|bool
     */
    public function getCmcInfo(\StructType\GetCmcInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCmcInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCredentialPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCredentialPolicyReq $axlParams
     * @return \StructType\GetCredentialPolicyRes|bool
     */
    public function getCredentialPolicy(\StructType\GetCredentialPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCredentialPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFacInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFacInfoReq $axlParams
     * @return \StructType\GetFacInfoRes|bool
     */
    public function getFacInfo(\StructType\GetFacInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFacInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHuntListReq $axlParams
     * @return \StructType\GetHuntListRes|bool
     */
    public function getHuntList(\StructType\GetHuntListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHuntList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIvrUserLocale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIvrUserLocaleReq $axlParams
     * @return \StructType\GetIvrUserLocaleRes|bool
     */
    public function getIvrUserLocale(\StructType\GetIvrUserLocaleReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIvrUserLocale($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLineGroupReq $axlParams
     * @return \StructType\GetLineGroupRes|bool
     */
    public function getLineGroup(\StructType\GetLineGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLineGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRecordingProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRecordingProfileReq $axlParams
     * @return \StructType\GetRecordingProfileRes|bool
     */
    public function getRecordingProfile(\StructType\GetRecordingProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRecordingProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteFilterReq $axlParams
     * @return \StructType\GetRouteFilterRes|bool
     */
    public function getRouteFilter(\StructType\GetRouteFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallManagerGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallManagerGroupReq $axlParams
     * @return \StructType\GetCallManagerGroupRes|bool
     */
    public function getCallManagerGroup(\StructType\GetCallManagerGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallManagerGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserGroupReq $axlParams
     * @return \StructType\GetUserGroupRes|bool
     */
    public function getUserGroup(\StructType\GetUserGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDialPlanReq $axlParams
     * @return \StructType\GetDialPlanRes|bool
     */
    public function getDialPlan(\StructType\GetDialPlanReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDialPlan($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDialPlanTag
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDialPlanTagReq $axlParams
     * @return \StructType\GetDialPlanTagRes|bool
     */
    public function getDialPlanTag(\StructType\GetDialPlanTagReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDialPlanTag($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDdi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDdiReq $axlParams
     * @return \StructType\GetDdiRes|bool
     */
    public function getDdi(\StructType\GetDdiReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDdi($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileSmartClientProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMobileSmartClientProfileReq $axlParams
     * @return \StructType\GetMobileSmartClientProfileRes|bool
     */
    public function getMobileSmartClientProfile(\StructType\GetMobileSmartClientProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobileSmartClientProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProcessNodeService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProcessNodeServiceReq $axlParams
     * @return \StructType\GetProcessNodeServiceRes|bool
     */
    public function getProcessNodeService(\StructType\GetProcessNodeServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getProcessNodeService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMohAudioSourceReq $axlParams
     * @return \StructType\GetMohAudioSourceRes|bool
     */
    public function getMohAudioSource(\StructType\GetMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDhcpServerReq $axlParams
     * @return \StructType\GetDhcpServerRes|bool
     */
    public function getDhcpServer(\StructType\GetDhcpServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDhcpServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDhcpSubnet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDhcpSubnetReq $axlParams
     * @return \StructType\GetDhcpSubnetRes|bool
     */
    public function getDhcpSubnet(\StructType\GetDhcpSubnetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDhcpSubnet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallParkReq $axlParams
     * @return \StructType\GetCallParkRes|bool
     */
    public function getCallPark(\StructType\GetCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectedCallPark
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDirectedCallParkReq $axlParams
     * @return \StructType\GetDirectedCallParkRes|bool
     */
    public function getDirectedCallPark(\StructType\GetDirectedCallParkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirectedCallPark($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMeetMe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMeetMeReq $axlParams
     * @return \StructType\GetMeetMeRes|bool
     */
    public function getMeetMe(\StructType\GetMeetMeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMeetMe($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobileVoiceAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMobileVoiceAccessReq $axlParams
     * @return \StructType\GetMobileVoiceAccessRes|bool
     */
    public function getMobileVoiceAccess(\StructType\GetMobileVoiceAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobileVoiceAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRouteList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteListReq $axlParams
     * @return \StructType\GetRouteListRes|bool
     */
    public function getRouteList(\StructType\GetRouteListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRouteList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserReq $axlParams
     * @return \StructType\GetUserRes|bool
     */
    public function getUser(\StructType\GetUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAppUserReq $axlParams
     * @return \StructType\GetAppUserRes|bool
     */
    public function getAppUser(\StructType\GetAppUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRealm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipRealmReq $axlParams
     * @return \StructType\GetSipRealmRes|bool
     */
    public function getSipRealm(\StructType\GetSipRealmReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipRealm($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneNtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneNtpReq $axlParams
     * @return \StructType\GetPhoneNtpRes|bool
     */
    public function getPhoneNtp(\StructType\GetPhoneNtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneNtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDateTimeGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDateTimeGroupReq $axlParams
     * @return \StructType\GetDateTimeGroupRes|bool
     */
    public function getDateTimeGroup(\StructType\GetDateTimeGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDateTimeGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPresenceGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPresenceGroupReq $axlParams
     * @return \StructType\GetPresenceGroupRes|bool
     */
    public function getPresenceGroup(\StructType\GetPresenceGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPresenceGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeoLocationReq $axlParams
     * @return \StructType\GetGeoLocationRes|bool
     */
    public function getGeoLocation(\StructType\GetGeoLocationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSrst
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSrstReq $axlParams
     * @return \StructType\GetSrstRes|bool
     */
    public function getSrst(\StructType\GetSrstReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSrst($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMlppDomain
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMlppDomainReq $axlParams
     * @return \StructType\GetMlppDomainRes|bool
     */
    public function getMlppDomain(\StructType\GetMlppDomainReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMlppDomain($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCumaServerSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCumaServerSecurityProfileReq $axlParams
     * @return \StructType\GetCumaServerSecurityProfileRes|bool
     */
    public function getCumaServerSecurityProfile(\StructType\GetCumaServerSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCumaServerSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApplicationServerReq $axlParams
     * @return \StructType\GetApplicationServerRes|bool
     */
    public function getApplicationServer(\StructType\GetApplicationServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApplicationUserCapfProfileReq $axlParams
     * @return \StructType\GetApplicationUserCapfProfileRes|bool
     */
    public function getApplicationUserCapfProfile(\StructType\GetApplicationUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEndUserCapfProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEndUserCapfProfileReq $axlParams
     * @return \StructType\GetEndUserCapfProfileRes|bool
     */
    public function getEndUserCapfProfile(\StructType\GetEndUserCapfProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEndUserCapfProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceParameter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceParameterReq $axlParams
     * @return \StructType\GetServiceParameterRes|bool
     */
    public function getServiceParameter(\StructType\GetServiceParameterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceParameter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeoLocationFilterReq $axlParams
     * @return \StructType\GetGeoLocationFilterRes|bool
     */
    public function getGeoLocationFilter(\StructType\GetGeoLocationFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocationFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoiceMailProfileReq $axlParams
     * @return \StructType\GetVoiceMailProfileRes|bool
     */
    public function getVoiceMailProfile(\StructType\GetVoiceMailProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoiceMailPort
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoiceMailPortReq $axlParams
     * @return \StructType\GetVoiceMailPortRes|bool
     */
    public function getVoiceMailPort(\StructType\GetVoiceMailPortReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVoiceMailPort($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatekeeper
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatekeeperReq $axlParams
     * @return \StructType\GetGatekeeperRes|bool
     */
    public function getGatekeeper(\StructType\GetGatekeeperReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatekeeper($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneButtonTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneButtonTemplateReq $axlParams
     * @return \StructType\GetPhoneButtonTemplateRes|bool
     */
    public function getPhoneButtonTemplate(\StructType\GetPhoneButtonTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneButtonTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCommonPhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCommonPhoneConfigReq $axlParams
     * @return \StructType\GetCommonPhoneConfigRes|bool
     */
    public function getCommonPhoneConfig(\StructType\GetCommonPhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCommonPhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMessageWaiting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMessageWaitingReq $axlParams
     * @return \StructType\GetMessageWaitingRes|bool
     */
    public function getMessageWaiting(\StructType\GetMessageWaitingReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMessageWaiting($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIpPhoneServices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIpPhoneServicesReq $axlParams
     * @return \StructType\GetIpPhoneServicesRes|bool
     */
    public function getIpPhoneServices(\StructType\GetIpPhoneServicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIpPhoneServices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCtiRoutePoint
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCtiRoutePointReq $axlParams
     * @return \StructType\GetCtiRoutePointRes|bool
     */
    public function getCtiRoutePoint(\StructType\GetCtiRoutePointReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCtiRoutePoint($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransPatternReq $axlParams
     * @return \StructType\GetTransPatternRes|bool
     */
    public function getTransPattern(\StructType\GetTransPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransPatternOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransPatternOptionsReq $axlParams
     * @return \StructType\GetTransPatternOptionsRes|bool
     */
    public function getTransPatternOptions(\StructType\GetTransPatternOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransPatternOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCallingPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallingPartyTransformationPatternReq $axlParams
     * @return \StructType\GetCallingPartyTransformationPatternRes|bool
     */
    public function getCallingPartyTransformationPattern(\StructType\GetCallingPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallingPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipRoutePatternReq $axlParams
     * @return \StructType\GetSipRoutePatternRes|bool
     */
    public function getSipRoutePattern(\StructType\GetSipRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHuntPilot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHuntPilotReq $axlParams
     * @return \StructType\GetHuntPilotRes|bool
     */
    public function getHuntPilot(\StructType\GetHuntPilotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHuntPilot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRoutePattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRoutePatternReq $axlParams
     * @return \StructType\GetRoutePatternRes|bool
     */
    public function getRoutePattern(\StructType\GetRoutePatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRoutePattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getApplicationDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetApplicationDialRulesReq $axlParams
     * @return \StructType\GetApplicationDialRulesRes|bool
     */
    public function getApplicationDialRules(\StructType\GetApplicationDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getApplicationDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirectoryLookupDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDirectoryLookupDialRulesReq $axlParams
     * @return \StructType\GetDirectoryLookupDialRulesRes|bool
     */
    public function getDirectoryLookupDialRules(\StructType\GetDirectoryLookupDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirectoryLookupDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneSecurityProfileReq $axlParams
     * @return \StructType\GetPhoneSecurityProfileRes|bool
     */
    public function getPhoneSecurityProfile(\StructType\GetPhoneSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipDialRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipDialRulesReq $axlParams
     * @return \StructType\GetSipDialRulesRes|bool
     */
    public function getSipDialRules(\StructType\GetSipDialRulesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipDialRules($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConferenceBridge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConferenceBridgeReq $axlParams
     * @return \StructType\GetConferenceBridgeRes|bool
     */
    public function getConferenceBridge(\StructType\GetConferenceBridgeReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getConferenceBridge($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnunciator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnnunciatorReq $axlParams
     * @return \StructType\GetAnnunciatorRes|bool
     */
    public function getAnnunciator(\StructType\GetAnnunciatorReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnnunciator($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMtp
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMtpReq $axlParams
     * @return \StructType\GetMtpRes|bool
     */
    public function getMtp(\StructType\GetMtpReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMtp($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFixedMohAudioSource
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFixedMohAudioSourceReq $axlParams
     * @return \StructType\GetFixedMohAudioSourceRes|bool
     */
    public function getFixedMohAudioSource(\StructType\GetFixedMohAudioSourceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFixedMohAudioSource($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestinationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRemoteDestinationProfileReq $axlParams
     * @return \StructType\GetRemoteDestinationProfileRes|bool
     */
    public function getRemoteDestinationProfile(\StructType\GetRemoteDestinationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteDestinationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLineReq $axlParams
     * @return \StructType\GetLineRes|bool
     */
    public function getLine(\StructType\GetLineReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLine($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLineOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLineOptionsReq $axlParams
     * @return \StructType\GetLineOptionsRes|bool
     */
    public function getLineOptions(\StructType\GetLineOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLineOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDefaultDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDefaultDeviceProfileReq $axlParams
     * @return \StructType\GetDefaultDeviceProfileRes|bool
     */
    public function getDefaultDeviceProfile(\StructType\GetDefaultDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDefaultDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Phone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetH323PhoneReq $axlParams
     * @return \StructType\GetH323PhoneRes|bool
     */
    public function getH323Phone(\StructType\GetH323PhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Phone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMohServerReq $axlParams
     * @return \StructType\GetMohServerRes|bool
     */
    public function getMohServer(\StructType\GetMohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Trunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetH323TrunkReq $axlParams
     * @return \StructType\GetH323TrunkRes|bool
     */
    public function getH323Trunk(\StructType\GetH323TrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Trunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneReq $axlParams
     * @return \StructType\GetPhoneRes|bool
     */
    public function getPhone(\StructType\GetPhoneReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhone($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneOptionsReq $axlParams
     * @return \StructType\GetPhoneOptionsRes|bool
     */
    public function getPhoneOptions(\StructType\GetPhoneOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getH323Gateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetH323GatewayReq $axlParams
     * @return \StructType\GetH323GatewayRes|bool
     */
    public function getH323Gateway(\StructType\GetH323GatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getH323Gateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceProfileReq $axlParams
     * @return \StructType\GetDeviceProfileRes|bool
     */
    public function getDeviceProfile(\StructType\GetDeviceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDeviceProfileOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeviceProfileOptionsReq $axlParams
     * @return \StructType\GetDeviceProfileOptionsRes|bool
     */
    public function getDeviceProfileOptions(\StructType\GetDeviceProfileOptionsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDeviceProfileOptions($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteDestination
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRemoteDestinationReq $axlParams
     * @return \StructType\GetRemoteDestinationRes|bool
     */
    public function getRemoteDestination(\StructType\GetRemoteDestinationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteDestination($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVg224
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVg224Req $axlParams
     * @return \StructType\GetVg224Res|bool
     */
    public function getVg224(\StructType\GetVg224Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVg224($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewayReq $axlParams
     * @return \StructType\GetGatewayRes|bool
     */
    public function getGateway(\StructType\GetGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointAnalogAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewayEndpointAnalogAccessReq $axlParams
     * @return \StructType\GetGatewayEndpointAnalogAccessRes|bool
     */
    public function getGatewayEndpointAnalogAccess(\StructType\GetGatewayEndpointAnalogAccessReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointAnalogAccess($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams
     * @return \StructType\GetGatewayEndpointDigitalAccessPriRes|bool
     */
    public function getGatewayEndpointDigitalAccessPri(\StructType\GetGatewayEndpointDigitalAccessPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessBri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams
     * @return \StructType\GetGatewayEndpointDigitalAccessBriRes|bool
     */
    public function getGatewayEndpointDigitalAccessBri(\StructType\GetGatewayEndpointDigitalAccessBriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessBri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewayEndpointDigitalAccessT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams
     * @return \StructType\GetGatewayEndpointDigitalAccessT1Res|bool
     */
    public function getGatewayEndpointDigitalAccessT1(\StructType\GetGatewayEndpointDigitalAccessT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewayEndpointDigitalAccessT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst600024PortFXSGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams
     * @return \StructType\GetCiscoCatalyst600024PortFXSGatewayRes|bool
     */
    public function getCiscoCatalyst600024PortFXSGateway(\StructType\GetCiscoCatalyst600024PortFXSGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst600024PortFXSGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCiscoCatalyst6000E1VoIPGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams
     * @return \StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|bool
     */
    public function getCiscoCatalyst6000E1VoIPGateway(\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000E1VoIPGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayPri
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams
     * @return \StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayPri(\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayPri($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCiscoCatalyst6000T1VoIPGatewayT1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams
     * @return \StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|bool
     */
    public function getCiscoCatalyst6000T1VoIPGatewayT1(\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCiscoCatalyst6000T1VoIPGatewayT1($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCallPickupGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCallPickupGroupReq $axlParams
     * @return \StructType\GetCallPickupGroupRes|bool
     */
    public function getCallPickupGroup(\StructType\GetCallPickupGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCallPickupGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGeoLocationPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGeoLocationPolicyReq $axlParams
     * @return \StructType\GetGeoLocationPolicyRes|bool
     */
    public function getGeoLocationPolicy(\StructType\GetGeoLocationPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGeoLocationPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSipTrunk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSipTrunkReq $axlParams
     * @return \StructType\GetSipTrunkRes|bool
     */
    public function getSipTrunk(\StructType\GetSipTrunkReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSipTrunk($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getCalledPartyTransformationPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCalledPartyTransformationPatternReq $axlParams
     * @return \StructType\GetCalledPartyTransformationPatternRes|bool
     */
    public function getCalledPartyTransformationPattern(\StructType\GetCalledPartyTransformationPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCalledPartyTransformationPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getExternalCallControlProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExternalCallControlProfileReq $axlParams
     * @return \StructType\GetExternalCallControlProfileRes|bool
     */
    public function getExternalCallControlProfile(\StructType\GetExternalCallControlProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getExternalCallControlProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafSecurityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSafSecurityProfileReq $axlParams
     * @return \StructType\GetSafSecurityProfileRes|bool
     */
    public function getSafSecurityProfile(\StructType\GetSafSecurityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafSecurityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafForwarder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSafForwarderReq $axlParams
     * @return \StructType\GetSafForwarderRes|bool
     */
    public function getSafForwarder(\StructType\GetSafForwarderReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafForwarder($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCcdHostedDNReq $axlParams
     * @return \StructType\GetCcdHostedDNRes|bool
     */
    public function getCcdHostedDN(\StructType\GetCcdHostedDNReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdHostedDN($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdHostedDNGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCcdHostedDNGroupReq $axlParams
     * @return \StructType\GetCcdHostedDNGroupRes|bool
     */
    public function getCcdHostedDNGroup(\StructType\GetCcdHostedDNGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdHostedDNGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdRequestingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCcdRequestingServiceReq $axlParams
     * @return \StructType\GetCcdRequestingServiceRes|bool
     */
    public function getCcdRequestingService(\StructType\GetCcdRequestingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdRequestingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getInterClusterServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInterClusterServiceProfileReq $axlParams
     * @return \StructType\GetInterClusterServiceProfileRes|bool
     */
    public function getInterClusterServiceProfile(\StructType\GetInterClusterServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getInterClusterServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRemoteCluster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRemoteClusterReq $axlParams
     * @return \StructType\GetRemoteClusterRes|bool
     */
    public function getRemoteCluster(\StructType\GetRemoteClusterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getRemoteCluster($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdAdvertisingService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCcdAdvertisingServiceReq $axlParams
     * @return \StructType\GetCcdAdvertisingServiceRes|bool
     */
    public function getCcdAdvertisingService(\StructType\GetCcdAdvertisingServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdAdvertisingService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapDirectory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapDirectoryReq $axlParams
     * @return \StructType\GetLdapDirectoryRes|bool
     */
    public function getLdapDirectory(\StructType\GetLdapDirectoryReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapDirectory($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEmccFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmccFeatureConfigReq $axlParams
     * @return \StructType\GetEmccFeatureConfigRes|bool
     */
    public function getEmccFeatureConfig(\StructType\GetEmccFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEmccFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSafCcdPurgeBlockLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams
     * @return \StructType\GetSafCcdPurgeBlockLearnedRoutesRes|bool
     */
    public function getSafCcdPurgeBlockLearnedRoutes(\StructType\GetSafCcdPurgeBlockLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSafCcdPurgeBlockLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVpnGatewayReq $axlParams
     * @return \StructType\GetVpnGatewayRes|bool
     */
    public function getVpnGateway(\StructType\GetVpnGatewayReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnGateway($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVpnGroupReq $axlParams
     * @return \StructType\GetVpnGroupRes|bool
     */
    public function getVpnGroup(\StructType\GetVpnGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVpnProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVpnProfileReq $axlParams
     * @return \StructType\GetVpnProfileRes|bool
     */
    public function getVpnProfile(\StructType\GetVpnProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVpnProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeServerReq $axlParams
     * @return \StructType\GetImeServerRes|bool
     */
    public function getImeServer(\StructType\GetImeServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeRouteFilterGroupReq $axlParams
     * @return \StructType\GetImeRouteFilterGroupRes|bool
     */
    public function getImeRouteFilterGroup(\StructType\GetImeRouteFilterGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeRouteFilterGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeRouteFilterElement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeRouteFilterElementReq $axlParams
     * @return \StructType\GetImeRouteFilterElementRes|bool
     */
    public function getImeRouteFilterElement(\StructType\GetImeRouteFilterElementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeRouteFilterElement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeClient
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeClientReq $axlParams
     * @return \StructType\GetImeClientRes|bool
     */
    public function getImeClient(\StructType\GetImeClientReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeClient($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPattern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeEnrolledPatternReq $axlParams
     * @return \StructType\GetImeEnrolledPatternRes|bool
     */
    public function getImeEnrolledPattern(\StructType\GetImeEnrolledPatternReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeEnrolledPattern($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeEnrolledPatternGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeEnrolledPatternGroupReq $axlParams
     * @return \StructType\GetImeEnrolledPatternGroupRes|bool
     */
    public function getImeEnrolledPatternGroup(\StructType\GetImeEnrolledPatternGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeEnrolledPatternGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeExclusionNumberReq $axlParams
     * @return \StructType\GetImeExclusionNumberRes|bool
     */
    public function getImeExclusionNumber(\StructType\GetImeExclusionNumberReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeExclusionNumber($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeExclusionNumberGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeExclusionNumberGroupReq $axlParams
     * @return \StructType\GetImeExclusionNumberGroupRes|bool
     */
    public function getImeExclusionNumberGroup(\StructType\GetImeExclusionNumberGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeExclusionNumberGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFirewall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeFirewallReq $axlParams
     * @return \StructType\GetImeFirewallRes|bool
     */
    public function getImeFirewall(\StructType\GetImeFirewallReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeFirewall($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeE164Transformation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeE164TransformationReq $axlParams
     * @return \StructType\GetImeE164TransformationRes|bool
     */
    public function getImeE164Transformation(\StructType\GetImeE164TransformationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeE164Transformation($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTransformationProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransformationProfileReq $axlParams
     * @return \StructType\GetTransformationProfileRes|bool
     */
    public function getTransformationProfile(\StructType\GetTransformationProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTransformationProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFallbackProfileReq $axlParams
     * @return \StructType\GetFallbackProfileRes|bool
     */
    public function getFallbackProfile(\StructType\GetFallbackProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFallbackProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapFilterReq $axlParams
     * @return \StructType\GetLdapFilterRes|bool
     */
    public function getLdapFilter(\StructType\GetLdapFilterReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapFilter($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTvsCertificate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTvsCertificateReq $axlParams
     * @return \StructType\GetTvsCertificateRes|bool
     */
    public function getTvsCertificate(\StructType\GetTvsCertificateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getTvsCertificate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeatureControlPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFeatureControlPolicyReq $axlParams
     * @return \StructType\GetFeatureControlPolicyRes|bool
     */
    public function getFeatureControlPolicy(\StructType\GetFeatureControlPolicyReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFeatureControlPolicy($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobilityProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMobilityProfileReq $axlParams
     * @return \StructType\GetMobilityProfileRes|bool
     */
    public function getMobilityProfile(\StructType\GetMobilityProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobilityProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getEnterpriseFeatureAccessConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams
     * @return \StructType\GetEnterpriseFeatureAccessConfigurationRes|bool
     */
    public function getEnterpriseFeatureAccessConfiguration(\StructType\GetEnterpriseFeatureAccessConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnterpriseFeatureAccessConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHandoffConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetHandoffConfigurationReq $axlParams
     * @return \StructType\GetHandoffConfigurationRes|bool
     */
    public function getHandoffConfiguration(\StructType\GetHandoffConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getHandoffConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSIPNormalizationScript
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSIPNormalizationScriptReq $axlParams
     * @return \StructType\GetSIPNormalizationScriptRes|bool
     */
    public function getSIPNormalizationScript(\StructType\GetSIPNormalizationScriptReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSIPNormalizationScript($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomUserField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomUserFieldReq $axlParams
     * @return \StructType\GetCustomUserFieldRes|bool
     */
    public function getCustomUserField(\StructType\GetCustomUserFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCustomUserField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getGatewaySccpEndpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGatewaySccpEndpointsReq $axlParams
     * @return \StructType\GetGatewaySccpEndpointsRes|bool
     */
    public function getGatewaySccpEndpoints(\StructType\GetGatewaySccpEndpointsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getGatewaySccpEndpoints($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLbmGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLbmGroupReq $axlParams
     * @return \StructType\GetLbmGroupRes|bool
     */
    public function getLbmGroup(\StructType\GetLbmGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLbmGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAnnouncement
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAnnouncementReq $axlParams
     * @return \StructType\GetAnnouncementRes|bool
     */
    public function getAnnouncement(\StructType\GetAnnouncementReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAnnouncement($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getServiceProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServiceProfileReq $axlParams
     * @return \StructType\GetServiceProfileRes|bool
     */
    public function getServiceProfile(\StructType\GetServiceProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getServiceProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSyncCustomField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapSyncCustomFieldReq $axlParams
     * @return \StructType\GetLdapSyncCustomFieldRes|bool
     */
    public function getLdapSyncCustomField(\StructType\GetLdapSyncCustomFieldReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSyncCustomField($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAudioCodecPreferenceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAudioCodecPreferenceListReq $axlParams
     * @return \StructType\GetAudioCodecPreferenceListRes|bool
     */
    public function getAudioCodecPreferenceList(\StructType\GetAudioCodecPreferenceListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAudioCodecPreferenceList($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUcService
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUcServiceReq $axlParams
     * @return \StructType\GetUcServiceRes|bool
     */
    public function getUcService(\StructType\GetUcServiceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUcService($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLbmHubGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLbmHubGroupReq $axlParams
     * @return \StructType\GetLbmHubGroupRes|bool
     */
    public function getLbmHubGroup(\StructType\GetLbmHubGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLbmHubGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImportedDirectoryUriCatalogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImportedDirectoryUriCatalogsReq $axlParams
     * @return \StructType\GetImportedDirectoryUriCatalogsRes|bool
     */
    public function getImportedDirectoryUriCatalogs(\StructType\GetImportedDirectoryUriCatalogsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImportedDirectoryUriCatalogs($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVohServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVohServerReq $axlParams
     * @return \StructType\GetVohServerRes|bool
     */
    public function getVohServer(\StructType\GetVohServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getVohServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSdpTransparencyProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSdpTransparencyProfileReq $axlParams
     * @return \StructType\GetSdpTransparencyProfileRes|bool
     */
    public function getSdpTransparencyProfile(\StructType\GetSdpTransparencyProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSdpTransparencyProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeatureGroupTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFeatureGroupTemplateReq $axlParams
     * @return \StructType\GetFeatureGroupTemplateRes|bool
     */
    public function getFeatureGroupTemplate(\StructType\GetFeatureGroupTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFeatureGroupTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDirNumberAliasLookupandSync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDirNumberAliasLookupandSyncReq $axlParams
     * @return \StructType\GetDirNumberAliasLookupandSyncRes|bool
     */
    public function getDirNumberAliasLookupandSync(\StructType\GetDirNumberAliasLookupandSyncReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getDirNumberAliasLookupandSync($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLocalRouteGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLocalRouteGroupReq $axlParams
     * @return \StructType\GetLocalRouteGroupRes|bool
     */
    public function getLocalRouteGroup(\StructType\GetLocalRouteGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLocalRouteGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdvertisedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAdvertisedPatternsReq $axlParams
     * @return \StructType\GetAdvertisedPatternsRes|bool
     */
    public function getAdvertisedPatterns(\StructType\GetAdvertisedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdvertisedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBlockedLearnedPatterns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBlockedLearnedPatternsReq $axlParams
     * @return \StructType\GetBlockedLearnedPatternsRes|bool
     */
    public function getBlockedLearnedPatterns(\StructType\GetBlockedLearnedPatternsReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getBlockedLearnedPatterns($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCCAProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCCAProfilesReq $axlParams
     * @return \StructType\GetCCAProfilesRes|bool
     */
    public function getCCAProfiles(\StructType\GetCCAProfilesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCCAProfiles($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUniversalDeviceTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUniversalDeviceTemplateReq $axlParams
     * @return \StructType\GetUniversalDeviceTemplateRes|bool
     */
    public function getUniversalDeviceTemplate(\StructType\GetUniversalDeviceTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUniversalDeviceTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserProfileProvision
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserProfileProvisionReq $axlParams
     * @return \StructType\GetUserProfileProvisionRes|bool
     */
    public function getUserProfileProvision(\StructType\GetUserProfileProvisionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUserProfileProvision($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPresenceRedundancyGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPresenceRedundancyGroupReq $axlParams
     * @return \StructType\GetPresenceRedundancyGroupRes|bool
     */
    public function getPresenceRedundancyGroup(\StructType\GetPresenceRedundancyGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPresenceRedundancyGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWifiHotspot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWifiHotspotReq $axlParams
     * @return \StructType\GetWifiHotspotRes|bool
     */
    public function getWifiHotspot(\StructType\GetWifiHotspotReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWifiHotspot($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWlanProfileGroup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWlanProfileGroupReq $axlParams
     * @return \StructType\GetWlanProfileGroupRes|bool
     */
    public function getWlanProfileGroup(\StructType\GetWlanProfileGroupReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWlanProfileGroup($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getWLANProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWLANProfileReq $axlParams
     * @return \StructType\GetWLANProfileRes|bool
     */
    public function getWLANProfile(\StructType\GetWLANProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getWLANProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUniversalLineTemplate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUniversalLineTemplateReq $axlParams
     * @return \StructType\GetUniversalLineTemplateRes|bool
     */
    public function getUniversalLineTemplate(\StructType\GetUniversalLineTemplateReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getUniversalLineTemplate($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNetworkAccessProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNetworkAccessProfileReq $axlParams
     * @return \StructType\GetNetworkAccessProfileRes|bool
     */
    public function getNetworkAccessProfile(\StructType\GetNetworkAccessProfileReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getNetworkAccessProfile($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLicensedUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLicensedUserReq $axlParams
     * @return \StructType\GetLicensedUserRes|bool
     */
    public function getLicensedUser(\StructType\GetLicensedUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLicensedUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOSVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOSVersionReq $axlParams
     * @return \StructType\GetOSVersionRes|bool
     */
    public function getOSVersion(\StructType\GetOSVersionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getOSVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNumDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNumDevicesReq $axlParams
     * @return \StructType\GetNumDevicesResponse|bool
     */
    public function getNumDevices(\StructType\GetNumDevicesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getNumDevices($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMobility
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMobilityReq $axlParams
     * @return \StructType\GetMobilityRes|bool
     */
    public function getMobility(\StructType\GetMobilityReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getMobility($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getEnterprisePhoneConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnterprisePhoneConfigReq $axlParams
     * @return \StructType\GetEnterprisePhoneConfigRes|bool
     */
    public function getEnterprisePhoneConfig(\StructType\GetEnterprisePhoneConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getEnterprisePhoneConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSystem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapSystemReq $axlParams
     * @return \StructType\GetLdapSystemRes|bool
     */
    public function getLdapSystem(\StructType\GetLdapSystemReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSystem($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapAuthentication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapAuthenticationReq $axlParams
     * @return \StructType\GetLdapAuthenticationRes|bool
     */
    public function getLdapAuthentication(\StructType\GetLdapAuthenticationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapAuthentication($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCCMVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCCMVersionReq $axlParams
     * @return \StructType\GetCCMVersionRes|bool
     */
    public function getCCMVersion(\StructType\GetCCMVersionReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCCMVersion($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeLearnedRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeLearnedRoutesReq $axlParams
     * @return \StructType\GetImeLearnedRoutesRes|bool
     */
    public function getImeLearnedRoutes(\StructType\GetImeLearnedRoutesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeLearnedRoutes($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getImeFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetImeFeatureConfigReq $axlParams
     * @return \StructType\GetImeFeatureConfigRes|bool
     */
    public function getImeFeatureConfig(\StructType\GetImeFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getImeFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFallbackFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFallbackFeatureConfigReq $axlParams
     * @return \StructType\GetFallbackFeatureConfigRes|bool
     */
    public function getFallbackFeatureConfig(\StructType\GetFallbackFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getFallbackFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAppServerInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAppServerInfoReq $axlParams
     * @return \StructType\GetAppServerInfoRes|bool
     */
    public function getAppServerInfo(\StructType\GetAppServerInfoReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getAppServerInfo($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLdapSyncStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLdapSyncStatusReq $axlParams
     * @return \StructType\GetLdapSyncStatusRes|bool
     */
    public function getLdapSyncStatus(\StructType\GetLdapSyncStatusReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getLdapSyncStatus($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSoftKeySet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSoftKeySetReq $axlParams
     * @return \StructType\GetSoftKeySetRes|bool
     */
    public function getSoftKeySet(\StructType\GetSoftKeySetReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSoftKeySet($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSyslogConfiguration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSyslogConfigurationReq $axlParams
     * @return \StructType\GetSyslogConfigurationRes|bool
     */
    public function getSyslogConfiguration(\StructType\GetSyslogConfigurationReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSyslogConfiguration($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPhoneTypeDisplayInstance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPhoneTypeDisplayInstanceReq $axlParams
     * @return \StructType\GetPhoneTypeDisplayInstanceRes|bool
     */
    public function getPhoneTypeDisplayInstance(\StructType\GetPhoneTypeDisplayInstanceReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPhoneTypeDisplayInstance($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIlsConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetIlsConfigReq $axlParams
     * @return \StructType\GetIlsConfigRes|bool
     */
    public function getIlsConfig(\StructType\GetIlsConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getIlsConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPCommunityString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSNMPCommunityStringReq $axlParams
     * @return \StructType\GetSNMPCommunityStringRes|bool
     */
    public function getSNMPCommunityString(\StructType\GetSNMPCommunityStringReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPCommunityString($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPUser
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSNMPUserReq $axlParams
     * @return \StructType\GetSNMPUserRes|bool
     */
    public function getSNMPUser(\StructType\GetSNMPUserReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPUser($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSNMPMIB2List
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSNMPMIB2ListReq $axlParams
     * @return \StructType\GetSNMPMIB2ListRes|bool
     */
    public function getSNMPMIB2List(\StructType\GetSNMPMIB2ListReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getSNMPMIB2List($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBillingServer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBillingServerReq $axlParams
     * @return \StructType\GetBillingServerRes|bool
     */
    public function getBillingServer(\StructType\GetBillingServerReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getBillingServer($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCcdFeatureConfig
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCcdFeatureConfigReq $axlParams
     * @return \StructType\GetCcdFeatureConfigRes|bool
     */
    public function getCcdFeatureConfig(\StructType\GetCcdFeatureConfigReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCcdFeatureConfig($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPageLayoutPreferences
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPageLayoutPreferencesReq $axlParams
     * @return \StructType\GetPageLayoutPreferencesRes|bool
     */
    public function getPageLayoutPreferences(\StructType\GetPageLayoutPreferencesReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getPageLayoutPreferences($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCredentialPolicyDefault
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCredentialPolicyDefaultReq $axlParams
     * @return \StructType\GetCredentialPolicyDefaultRes|bool
     */
    public function getCredentialPolicyDefault(\StructType\GetCredentialPolicyDefaultReq $axlParams)
    {
        try {
            $this->setResult($this->getSoapClient()->getCredentialPolicyDefault($axlParams));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAarGroupRes|\StructType\GetAdvertisedPatternsRes|\StructType\GetAnnouncementRes|\StructType\GetAnnunciatorRes|\StructType\GetApplicationDialRulesRes|\StructType\GetApplicationServerRes|\StructType\GetApplicationUserCapfProfileRes|\StructType\GetAppServerInfoRes|\StructType\GetAppUserRes|\StructType\GetAudioCodecPreferenceListRes|\StructType\GetBillingServerRes|\StructType\GetBlockedLearnedPatternsRes|\StructType\GetCalledPartyTransformationPatternRes|\StructType\GetCallerFilterListRes|\StructType\GetCallingPartyTransformationPatternRes|\StructType\GetCallManagerGroupRes|\StructType\GetCallManagerRes|\StructType\GetCallParkRes|\StructType\GetCallPickupGroupRes|\StructType\GetCCAProfilesRes|\StructType\GetCcdAdvertisingServiceRes|\StructType\GetCcdFeatureConfigRes|\StructType\GetCcdHostedDNGroupRes|\StructType\GetCcdHostedDNRes|\StructType\GetCcdRequestingServiceRes|\StructType\GetCCMVersionRes|\StructType\GetCiscoCatalyst6000E1VoIPGatewayRes|\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriRes|\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Res|\StructType\GetCiscoCatalyst600024PortFXSGatewayRes|\StructType\GetCmcInfoRes|\StructType\GetCommonDeviceConfigRes|\StructType\GetCommonPhoneConfigRes|\StructType\GetConferenceBridgeRes|\StructType\GetCredentialPolicyDefaultRes|\StructType\GetCredentialPolicyRes|\StructType\GetCssRes|\StructType\GetCtiRoutePointRes|\StructType\GetCumaServerSecurityProfileRes|\StructType\GetCustomUserFieldRes|\StructType\GetDateTimeGroupRes|\StructType\GetDdiRes|\StructType\GetDefaultDeviceProfileRes|\StructType\GetDeviceMobilityGroupRes|\StructType\GetDeviceMobilityRes|\StructType\GetDevicePoolRes|\StructType\GetDeviceProfileOptionsRes|\StructType\GetDeviceProfileRes|\StructType\GetDhcpServerRes|\StructType\GetDhcpSubnetRes|\StructType\GetDialPlanRes|\StructType\GetDialPlanTagRes|\StructType\GetDirectedCallParkRes|\StructType\GetDirectoryLookupDialRulesRes|\StructType\GetDirNumberAliasLookupandSyncRes|\StructType\GetEmccFeatureConfigRes|\StructType\GetEndUserCapfProfileRes|\StructType\GetEnterpriseFeatureAccessConfigurationRes|\StructType\GetEnterprisePhoneConfigRes|\StructType\GetExternalCallControlProfileRes|\StructType\GetFacInfoRes|\StructType\GetFallbackFeatureConfigRes|\StructType\GetFallbackProfileRes|\StructType\GetFeatureControlPolicyRes|\StructType\GetFeatureGroupTemplateRes|\StructType\GetFixedMohAudioSourceRes|\StructType\GetGatekeeperRes|\StructType\GetGatewayEndpointAnalogAccessRes|\StructType\GetGatewayEndpointDigitalAccessBriRes|\StructType\GetGatewayEndpointDigitalAccessPriRes|\StructType\GetGatewayEndpointDigitalAccessT1Res|\StructType\GetGatewayRes|\StructType\GetGatewaySccpEndpointsRes|\StructType\GetGeoLocationFilterRes|\StructType\GetGeoLocationPolicyRes|\StructType\GetGeoLocationRes|\StructType\GetH323GatewayRes|\StructType\GetH323PhoneRes|\StructType\GetH323TrunkRes|\StructType\GetHandoffConfigurationRes|\StructType\GetHuntListRes|\StructType\GetHuntPilotRes|\StructType\GetIlsConfigRes|\StructType\GetImeClientRes|\StructType\GetImeE164TransformationRes|\StructType\GetImeEnrolledPatternGroupRes|\StructType\GetImeEnrolledPatternRes|\StructType\GetImeExclusionNumberGroupRes|\StructType\GetImeExclusionNumberRes|\StructType\GetImeFeatureConfigRes|\StructType\GetImeFirewallRes|\StructType\GetImeLearnedRoutesRes|\StructType\GetImeRouteFilterElementRes|\StructType\GetImeRouteFilterGroupRes|\StructType\GetImeServerRes|\StructType\GetImportedDirectoryUriCatalogsRes|\StructType\GetInterClusterServiceProfileRes|\StructType\GetIpPhoneServicesRes|\StructType\GetIvrUserLocaleRes|\StructType\GetLbmGroupRes|\StructType\GetLbmHubGroupRes|\StructType\GetLdapAuthenticationRes|\StructType\GetLdapDirectoryRes|\StructType\GetLdapFilterRes|\StructType\GetLdapSyncCustomFieldRes|\StructType\GetLdapSyncStatusRes|\StructType\GetLdapSystemRes|\StructType\GetLicensedUserRes|\StructType\GetLineGroupRes|\StructType\GetLineOptionsRes|\StructType\GetLineRes|\StructType\GetLocalRouteGroupRes|\StructType\GetLocationRes|\StructType\GetMediaResourceGroupRes|\StructType\GetMediaResourceListRes|\StructType\GetMeetMeRes|\StructType\GetMessageWaitingRes|\StructType\GetMlppDomainRes|\StructType\GetMobileSmartClientProfileRes|\StructType\GetMobileVoiceAccessRes|\StructType\GetMobilityProfileRes|\StructType\GetMobilityRes|\StructType\GetMohAudioSourceRes|\StructType\GetMohServerRes|\StructType\GetMtpRes|\StructType\GetNetworkAccessProfileRes|\StructType\GetNumDevicesResponse|\StructType\GetOSVersionRes|\StructType\GetPageLayoutPreferencesRes|\StructType\GetPhoneButtonTemplateRes|\StructType\GetPhoneNtpRes|\StructType\GetPhoneOptionsRes|\StructType\GetPhoneRes|\StructType\GetPhoneSecurityProfileRes|\StructType\GetPhoneTypeDisplayInstanceRes|\StructType\GetPhysicalLocationRes|\StructType\GetPresenceGroupRes|\StructType\GetPresenceRedundancyGroupRes|\StructType\GetProcessNodeRes|\StructType\GetProcessNodeServiceRes|\StructType\GetRecordingProfileRes|\StructType\GetRegionRes|\StructType\GetRemoteClusterRes|\StructType\GetRemoteDestinationProfileRes|\StructType\GetRemoteDestinationRes|\StructType\GetResourcePriorityNamespaceListRes|\StructType\GetResourcePriorityNamespaceRes|\StructType\GetRouteFilterRes|\StructType\GetRouteGroupRes|\StructType\GetRouteListRes|\StructType\GetRoutePartitionRes|\StructType\GetRoutePatternRes|\StructType\GetSafCcdPurgeBlockLearnedRoutesRes|\StructType\GetSafForwarderRes|\StructType\GetSafSecurityProfileRes|\StructType\GetSdpTransparencyProfileRes|\StructType\GetServiceParameterRes|\StructType\GetServiceProfileRes|\StructType\GetSipDialRulesRes|\StructType\GetSIPNormalizationScriptRes|\StructType\GetSipProfileOptionsRes|\StructType\GetSipProfileRes|\StructType\GetSipRealmRes|\StructType\GetSipRoutePatternRes|\StructType\GetSipTrunkRes|\StructType\GetSipTrunkSecurityProfileRes|\StructType\GetSNMPCommunityStringRes|\StructType\GetSNMPMIB2ListRes|\StructType\GetSNMPUserRes|\StructType\GetSoftKeySetRes|\StructType\GetSoftKeyTemplateRes|\StructType\GetSrstRes|\StructType\GetSyslogConfigurationRes|\StructType\GetTimePeriodRes|\StructType\GetTimeScheduleRes|\StructType\GetTodAccessRes|\StructType\GetTranscoderRes|\StructType\GetTransformationProfileRes|\StructType\GetTransPatternOptionsRes|\StructType\GetTransPatternRes|\StructType\GetTvsCertificateRes|\StructType\GetUcServiceRes|\StructType\GetUniversalDeviceTemplateRes|\StructType\GetUniversalLineTemplateRes|\StructType\GetUserGroupRes|\StructType\GetUserProfileProvisionRes|\StructType\GetUserRes|\StructType\GetVg224Res|\StructType\GetVohServerRes|\StructType\GetVoiceMailPilotRes|\StructType\GetVoiceMailPortRes|\StructType\GetVoiceMailProfileRes|\StructType\GetVpnGatewayRes|\StructType\GetVpnGroupRes|\StructType\GetVpnProfileRes|\StructType\GetWifiHotspotRes|\StructType\GetWlanProfileGroupRes|\StructType\GetWLANProfileRes
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
