<?php

namespace LogBook\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpragueNumbers StructType
 * @subpackage Structs
 */
class SpragueNumbers extends AbstractStructBase
{
    /**
     * The SpragueNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SpragueNumber;
    /**
     * Constructor method for SpragueNumbers
     * @uses SpragueNumbers::setSpragueNumber()
     * @param int $spragueNumber
     */
    public function __construct($spragueNumber = null)
    {
        $this
            ->setSpragueNumber($spragueNumber);
    }
    /**
     * Get SpragueNumber value
     * @return int
     */
    public function getSpragueNumber()
    {
        return $this->SpragueNumber;
    }
    /**
     * Set SpragueNumber value
     * @param int $spragueNumber
     * @return \LogBook\StructType\SpragueNumbers
     */
    public function setSpragueNumber($spragueNumber = null)
    {
        // validation for constraint: int
        if (!is_null($spragueNumber) && !(is_int($spragueNumber) || ctype_digit($spragueNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($spragueNumber, true), gettype($spragueNumber)), __LINE__);
        }
        $this->SpragueNumber = $spragueNumber;
        return $this;
    }
}
