<?php

namespace LogBook\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDSandLabelWithoutFiles StructType
 * @subpackage Structs
 */
class SDSandLabelWithoutFiles extends AbstractStructBase
{
    /**
     * The SpragueNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SpragueNumber;
    /**
     * The SDSFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SDSFileUpdateTime;
    /**
     * The LabelFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LabelFileUpdateTime;
    /**
     * The CALabelFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CALabelFileUpdateTime;
    /**
     * The OtherFileLastUpdatedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OtherFileLastUpdatedDate;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryId;
    /**
     * The MaterialName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaterialName;
    /**
     * The EPANumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EPANumber;
    /**
     * The SDSFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SDSFileName;
    /**
     * The LabelFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelFileName;
    /**
     * The CALabelFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CALabelFileName;
    /**
     * The Other
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other;
    /**
     * The OtherFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherFileName;
    /**
     * The OtherFilePath
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherFilePath;
    /**
     * Constructor method for SDSandLabelWithoutFiles
     * @uses SDSandLabelWithoutFiles::setSpragueNumber()
     * @uses SDSandLabelWithoutFiles::setSDSFileUpdateTime()
     * @uses SDSandLabelWithoutFiles::setLabelFileUpdateTime()
     * @uses SDSandLabelWithoutFiles::setCALabelFileUpdateTime()
     * @uses SDSandLabelWithoutFiles::setOtherFileLastUpdatedDate()
     * @uses SDSandLabelWithoutFiles::setCategoryId()
     * @uses SDSandLabelWithoutFiles::setMaterialName()
     * @uses SDSandLabelWithoutFiles::setEPANumber()
     * @uses SDSandLabelWithoutFiles::setSDSFileName()
     * @uses SDSandLabelWithoutFiles::setLabelFileName()
     * @uses SDSandLabelWithoutFiles::setCALabelFileName()
     * @uses SDSandLabelWithoutFiles::setOther()
     * @uses SDSandLabelWithoutFiles::setOtherFileName()
     * @uses SDSandLabelWithoutFiles::setOtherFilePath()
     * @param int $spragueNumber
     * @param string $sDSFileUpdateTime
     * @param string $labelFileUpdateTime
     * @param string $cALabelFileUpdateTime
     * @param string $otherFileLastUpdatedDate
     * @param string $categoryId
     * @param string $materialName
     * @param string $ePANumber
     * @param string $sDSFileName
     * @param string $labelFileName
     * @param string $cALabelFileName
     * @param string $other
     * @param string $otherFileName
     * @param string $otherFilePath
     */
    public function __construct($spragueNumber = null, $sDSFileUpdateTime = null, $labelFileUpdateTime = null, $cALabelFileUpdateTime = null, $otherFileLastUpdatedDate = null, $categoryId = null, $materialName = null, $ePANumber = null, $sDSFileName = null, $labelFileName = null, $cALabelFileName = null, $other = null, $otherFileName = null, $otherFilePath = null)
    {
        $this
            ->setSpragueNumber($spragueNumber)
            ->setSDSFileUpdateTime($sDSFileUpdateTime)
            ->setLabelFileUpdateTime($labelFileUpdateTime)
            ->setCALabelFileUpdateTime($cALabelFileUpdateTime)
            ->setOtherFileLastUpdatedDate($otherFileLastUpdatedDate)
            ->setCategoryId($categoryId)
            ->setMaterialName($materialName)
            ->setEPANumber($ePANumber)
            ->setSDSFileName($sDSFileName)
            ->setLabelFileName($labelFileName)
            ->setCALabelFileName($cALabelFileName)
            ->setOther($other)
            ->setOtherFileName($otherFileName)
            ->setOtherFilePath($otherFilePath);
    }
    /**
     * Get SpragueNumber value
     * @return int
     */
    public function getSpragueNumber()
    {
        return $this->SpragueNumber;
    }
    /**
     * Set SpragueNumber value
     * @param int $spragueNumber
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setSpragueNumber($spragueNumber = null)
    {
        // validation for constraint: int
        if (!is_null($spragueNumber) && !(is_int($spragueNumber) || ctype_digit($spragueNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($spragueNumber, true), gettype($spragueNumber)), __LINE__);
        }
        $this->SpragueNumber = $spragueNumber;
        return $this;
    }
    /**
     * Get SDSFileUpdateTime value
     * @return string
     */
    public function getSDSFileUpdateTime()
    {
        return $this->SDSFileUpdateTime;
    }
    /**
     * Set SDSFileUpdateTime value
     * @param string $sDSFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setSDSFileUpdateTime($sDSFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sDSFileUpdateTime) && !is_string($sDSFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDSFileUpdateTime, true), gettype($sDSFileUpdateTime)), __LINE__);
        }
        $this->SDSFileUpdateTime = $sDSFileUpdateTime;
        return $this;
    }
    /**
     * Get LabelFileUpdateTime value
     * @return string
     */
    public function getLabelFileUpdateTime()
    {
        return $this->LabelFileUpdateTime;
    }
    /**
     * Set LabelFileUpdateTime value
     * @param string $labelFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setLabelFileUpdateTime($labelFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileUpdateTime) && !is_string($labelFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFileUpdateTime, true), gettype($labelFileUpdateTime)), __LINE__);
        }
        $this->LabelFileUpdateTime = $labelFileUpdateTime;
        return $this;
    }
    /**
     * Get CALabelFileUpdateTime value
     * @return string
     */
    public function getCALabelFileUpdateTime()
    {
        return $this->CALabelFileUpdateTime;
    }
    /**
     * Set CALabelFileUpdateTime value
     * @param string $cALabelFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setCALabelFileUpdateTime($cALabelFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($cALabelFileUpdateTime) && !is_string($cALabelFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cALabelFileUpdateTime, true), gettype($cALabelFileUpdateTime)), __LINE__);
        }
        $this->CALabelFileUpdateTime = $cALabelFileUpdateTime;
        return $this;
    }
    /**
     * Get OtherFileLastUpdatedDate value
     * @return string
     */
    public function getOtherFileLastUpdatedDate()
    {
        return $this->OtherFileLastUpdatedDate;
    }
    /**
     * Set OtherFileLastUpdatedDate value
     * @param string $otherFileLastUpdatedDate
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setOtherFileLastUpdatedDate($otherFileLastUpdatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($otherFileLastUpdatedDate) && !is_string($otherFileLastUpdatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFileLastUpdatedDate, true), gettype($otherFileLastUpdatedDate)), __LINE__);
        }
        $this->OtherFileLastUpdatedDate = $otherFileLastUpdatedDate;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get MaterialName value
     * @return string|null
     */
    public function getMaterialName()
    {
        return $this->MaterialName;
    }
    /**
     * Set MaterialName value
     * @param string $materialName
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setMaterialName($materialName = null)
    {
        // validation for constraint: string
        if (!is_null($materialName) && !is_string($materialName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialName, true), gettype($materialName)), __LINE__);
        }
        $this->MaterialName = $materialName;
        return $this;
    }
    /**
     * Get EPANumber value
     * @return string|null
     */
    public function getEPANumber()
    {
        return $this->EPANumber;
    }
    /**
     * Set EPANumber value
     * @param string $ePANumber
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setEPANumber($ePANumber = null)
    {
        // validation for constraint: string
        if (!is_null($ePANumber) && !is_string($ePANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePANumber, true), gettype($ePANumber)), __LINE__);
        }
        $this->EPANumber = $ePANumber;
        return $this;
    }
    /**
     * Get SDSFileName value
     * @return string|null
     */
    public function getSDSFileName()
    {
        return $this->SDSFileName;
    }
    /**
     * Set SDSFileName value
     * @param string $sDSFileName
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setSDSFileName($sDSFileName = null)
    {
        // validation for constraint: string
        if (!is_null($sDSFileName) && !is_string($sDSFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDSFileName, true), gettype($sDSFileName)), __LINE__);
        }
        $this->SDSFileName = $sDSFileName;
        return $this;
    }
    /**
     * Get LabelFileName value
     * @return string|null
     */
    public function getLabelFileName()
    {
        return $this->LabelFileName;
    }
    /**
     * Set LabelFileName value
     * @param string $labelFileName
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setLabelFileName($labelFileName = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileName) && !is_string($labelFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFileName, true), gettype($labelFileName)), __LINE__);
        }
        $this->LabelFileName = $labelFileName;
        return $this;
    }
    /**
     * Get CALabelFileName value
     * @return string|null
     */
    public function getCALabelFileName()
    {
        return $this->CALabelFileName;
    }
    /**
     * Set CALabelFileName value
     * @param string $cALabelFileName
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setCALabelFileName($cALabelFileName = null)
    {
        // validation for constraint: string
        if (!is_null($cALabelFileName) && !is_string($cALabelFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cALabelFileName, true), gettype($cALabelFileName)), __LINE__);
        }
        $this->CALabelFileName = $cALabelFileName;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setOther($other = null)
    {
        // validation for constraint: string
        if (!is_null($other) && !is_string($other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($other, true), gettype($other)), __LINE__);
        }
        $this->Other = $other;
        return $this;
    }
    /**
     * Get OtherFileName value
     * @return string|null
     */
    public function getOtherFileName()
    {
        return $this->OtherFileName;
    }
    /**
     * Set OtherFileName value
     * @param string $otherFileName
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setOtherFileName($otherFileName = null)
    {
        // validation for constraint: string
        if (!is_null($otherFileName) && !is_string($otherFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFileName, true), gettype($otherFileName)), __LINE__);
        }
        $this->OtherFileName = $otherFileName;
        return $this;
    }
    /**
     * Get OtherFilePath value
     * @return string|null
     */
    public function getOtherFilePath()
    {
        return $this->OtherFilePath;
    }
    /**
     * Set OtherFilePath value
     * @param string $otherFilePath
     * @return \LogBook\StructType\SDSandLabelWithoutFiles
     */
    public function setOtherFilePath($otherFilePath = null)
    {
        // validation for constraint: string
        if (!is_null($otherFilePath) && !is_string($otherFilePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFilePath, true), gettype($otherFilePath)), __LINE__);
        }
        $this->OtherFilePath = $otherFilePath;
        return $this;
    }
}
