<?php

namespace LogBook\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDSandLabelFiles StructType
 * @subpackage Structs
 */
class SDSandLabelFiles extends AbstractStructBase
{
    /**
     * The SpragueNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SpragueNumber;
    /**
     * The SDSFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SDSFileUpdateTime;
    /**
     * The SDSFileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SDSFileSize;
    /**
     * The LabelFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LabelFileUpdateTime;
    /**
     * The LabelFileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $LabelFileSize;
    /**
     * The CALabelFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CALabelFileUpdateTime;
    /**
     * The CALabelFileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CALabelFileSize;
    /**
     * The OtherFileUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $OtherFileUpdateTime;
    /**
     * The OtherFileSize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OtherFileSize;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryId;
    /**
     * The MaterialName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MaterialName;
    /**
     * The EPANumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EPANumber;
    /**
     * The SDSFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SDSFileName;
    /**
     * The SDSFileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SDSFileContent;
    /**
     * The LabelFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelFileName;
    /**
     * The LabelFileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelFileContent;
    /**
     * The ChecksumSDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChecksumSDS;
    /**
     * The ChecksumLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChecksumLabel;
    /**
     * The CALabelFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CALabelFileName;
    /**
     * The CALabelFileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CALabelFileContent;
    /**
     * The ChecksumCALabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChecksumCALabel;
    /**
     * The Other
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Other;
    /**
     * The OtherFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherFileName;
    /**
     * The OtherFileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OtherFileContent;
    /**
     * The ChecksumOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChecksumOther;
    /**
     * Constructor method for SDSandLabelFiles
     * @uses SDSandLabelFiles::setSpragueNumber()
     * @uses SDSandLabelFiles::setSDSFileUpdateTime()
     * @uses SDSandLabelFiles::setSDSFileSize()
     * @uses SDSandLabelFiles::setLabelFileUpdateTime()
     * @uses SDSandLabelFiles::setLabelFileSize()
     * @uses SDSandLabelFiles::setCALabelFileUpdateTime()
     * @uses SDSandLabelFiles::setCALabelFileSize()
     * @uses SDSandLabelFiles::setOtherFileUpdateTime()
     * @uses SDSandLabelFiles::setOtherFileSize()
     * @uses SDSandLabelFiles::setCategoryId()
     * @uses SDSandLabelFiles::setMaterialName()
     * @uses SDSandLabelFiles::setEPANumber()
     * @uses SDSandLabelFiles::setSDSFileName()
     * @uses SDSandLabelFiles::setSDSFileContent()
     * @uses SDSandLabelFiles::setLabelFileName()
     * @uses SDSandLabelFiles::setLabelFileContent()
     * @uses SDSandLabelFiles::setChecksumSDS()
     * @uses SDSandLabelFiles::setChecksumLabel()
     * @uses SDSandLabelFiles::setCALabelFileName()
     * @uses SDSandLabelFiles::setCALabelFileContent()
     * @uses SDSandLabelFiles::setChecksumCALabel()
     * @uses SDSandLabelFiles::setOther()
     * @uses SDSandLabelFiles::setOtherFileName()
     * @uses SDSandLabelFiles::setOtherFileContent()
     * @uses SDSandLabelFiles::setChecksumOther()
     * @param int $spragueNumber
     * @param string $sDSFileUpdateTime
     * @param int $sDSFileSize
     * @param string $labelFileUpdateTime
     * @param int $labelFileSize
     * @param string $cALabelFileUpdateTime
     * @param int $cALabelFileSize
     * @param string $otherFileUpdateTime
     * @param int $otherFileSize
     * @param string $categoryId
     * @param string $materialName
     * @param string $ePANumber
     * @param string $sDSFileName
     * @param string $sDSFileContent
     * @param string $labelFileName
     * @param string $labelFileContent
     * @param string $checksumSDS
     * @param string $checksumLabel
     * @param string $cALabelFileName
     * @param string $cALabelFileContent
     * @param string $checksumCALabel
     * @param string $other
     * @param string $otherFileName
     * @param string $otherFileContent
     * @param string $checksumOther
     */
    public function __construct($spragueNumber = null, $sDSFileUpdateTime = null, $sDSFileSize = null, $labelFileUpdateTime = null, $labelFileSize = null, $cALabelFileUpdateTime = null, $cALabelFileSize = null, $otherFileUpdateTime = null, $otherFileSize = null, $categoryId = null, $materialName = null, $ePANumber = null, $sDSFileName = null, $sDSFileContent = null, $labelFileName = null, $labelFileContent = null, $checksumSDS = null, $checksumLabel = null, $cALabelFileName = null, $cALabelFileContent = null, $checksumCALabel = null, $other = null, $otherFileName = null, $otherFileContent = null, $checksumOther = null)
    {
        $this
            ->setSpragueNumber($spragueNumber)
            ->setSDSFileUpdateTime($sDSFileUpdateTime)
            ->setSDSFileSize($sDSFileSize)
            ->setLabelFileUpdateTime($labelFileUpdateTime)
            ->setLabelFileSize($labelFileSize)
            ->setCALabelFileUpdateTime($cALabelFileUpdateTime)
            ->setCALabelFileSize($cALabelFileSize)
            ->setOtherFileUpdateTime($otherFileUpdateTime)
            ->setOtherFileSize($otherFileSize)
            ->setCategoryId($categoryId)
            ->setMaterialName($materialName)
            ->setEPANumber($ePANumber)
            ->setSDSFileName($sDSFileName)
            ->setSDSFileContent($sDSFileContent)
            ->setLabelFileName($labelFileName)
            ->setLabelFileContent($labelFileContent)
            ->setChecksumSDS($checksumSDS)
            ->setChecksumLabel($checksumLabel)
            ->setCALabelFileName($cALabelFileName)
            ->setCALabelFileContent($cALabelFileContent)
            ->setChecksumCALabel($checksumCALabel)
            ->setOther($other)
            ->setOtherFileName($otherFileName)
            ->setOtherFileContent($otherFileContent)
            ->setChecksumOther($checksumOther);
    }
    /**
     * Get SpragueNumber value
     * @return int
     */
    public function getSpragueNumber()
    {
        return $this->SpragueNumber;
    }
    /**
     * Set SpragueNumber value
     * @param int $spragueNumber
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setSpragueNumber($spragueNumber = null)
    {
        // validation for constraint: int
        if (!is_null($spragueNumber) && !(is_int($spragueNumber) || ctype_digit($spragueNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($spragueNumber, true), gettype($spragueNumber)), __LINE__);
        }
        $this->SpragueNumber = $spragueNumber;
        return $this;
    }
    /**
     * Get SDSFileUpdateTime value
     * @return string
     */
    public function getSDSFileUpdateTime()
    {
        return $this->SDSFileUpdateTime;
    }
    /**
     * Set SDSFileUpdateTime value
     * @param string $sDSFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setSDSFileUpdateTime($sDSFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sDSFileUpdateTime) && !is_string($sDSFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDSFileUpdateTime, true), gettype($sDSFileUpdateTime)), __LINE__);
        }
        $this->SDSFileUpdateTime = $sDSFileUpdateTime;
        return $this;
    }
    /**
     * Get SDSFileSize value
     * @return int
     */
    public function getSDSFileSize()
    {
        return $this->SDSFileSize;
    }
    /**
     * Set SDSFileSize value
     * @param int $sDSFileSize
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setSDSFileSize($sDSFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($sDSFileSize) && !(is_int($sDSFileSize) || ctype_digit($sDSFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sDSFileSize, true), gettype($sDSFileSize)), __LINE__);
        }
        $this->SDSFileSize = $sDSFileSize;
        return $this;
    }
    /**
     * Get LabelFileUpdateTime value
     * @return string
     */
    public function getLabelFileUpdateTime()
    {
        return $this->LabelFileUpdateTime;
    }
    /**
     * Set LabelFileUpdateTime value
     * @param string $labelFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setLabelFileUpdateTime($labelFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileUpdateTime) && !is_string($labelFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFileUpdateTime, true), gettype($labelFileUpdateTime)), __LINE__);
        }
        $this->LabelFileUpdateTime = $labelFileUpdateTime;
        return $this;
    }
    /**
     * Get LabelFileSize value
     * @return int
     */
    public function getLabelFileSize()
    {
        return $this->LabelFileSize;
    }
    /**
     * Set LabelFileSize value
     * @param int $labelFileSize
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setLabelFileSize($labelFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($labelFileSize) && !(is_int($labelFileSize) || ctype_digit($labelFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($labelFileSize, true), gettype($labelFileSize)), __LINE__);
        }
        $this->LabelFileSize = $labelFileSize;
        return $this;
    }
    /**
     * Get CALabelFileUpdateTime value
     * @return string
     */
    public function getCALabelFileUpdateTime()
    {
        return $this->CALabelFileUpdateTime;
    }
    /**
     * Set CALabelFileUpdateTime value
     * @param string $cALabelFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setCALabelFileUpdateTime($cALabelFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($cALabelFileUpdateTime) && !is_string($cALabelFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cALabelFileUpdateTime, true), gettype($cALabelFileUpdateTime)), __LINE__);
        }
        $this->CALabelFileUpdateTime = $cALabelFileUpdateTime;
        return $this;
    }
    /**
     * Get CALabelFileSize value
     * @return int
     */
    public function getCALabelFileSize()
    {
        return $this->CALabelFileSize;
    }
    /**
     * Set CALabelFileSize value
     * @param int $cALabelFileSize
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setCALabelFileSize($cALabelFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($cALabelFileSize) && !(is_int($cALabelFileSize) || ctype_digit($cALabelFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cALabelFileSize, true), gettype($cALabelFileSize)), __LINE__);
        }
        $this->CALabelFileSize = $cALabelFileSize;
        return $this;
    }
    /**
     * Get OtherFileUpdateTime value
     * @return string
     */
    public function getOtherFileUpdateTime()
    {
        return $this->OtherFileUpdateTime;
    }
    /**
     * Set OtherFileUpdateTime value
     * @param string $otherFileUpdateTime
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setOtherFileUpdateTime($otherFileUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($otherFileUpdateTime) && !is_string($otherFileUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFileUpdateTime, true), gettype($otherFileUpdateTime)), __LINE__);
        }
        $this->OtherFileUpdateTime = $otherFileUpdateTime;
        return $this;
    }
    /**
     * Get OtherFileSize value
     * @return int
     */
    public function getOtherFileSize()
    {
        return $this->OtherFileSize;
    }
    /**
     * Set OtherFileSize value
     * @param int $otherFileSize
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setOtherFileSize($otherFileSize = null)
    {
        // validation for constraint: int
        if (!is_null($otherFileSize) && !(is_int($otherFileSize) || ctype_digit($otherFileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($otherFileSize, true), gettype($otherFileSize)), __LINE__);
        }
        $this->OtherFileSize = $otherFileSize;
        return $this;
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get MaterialName value
     * @return string|null
     */
    public function getMaterialName()
    {
        return $this->MaterialName;
    }
    /**
     * Set MaterialName value
     * @param string $materialName
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setMaterialName($materialName = null)
    {
        // validation for constraint: string
        if (!is_null($materialName) && !is_string($materialName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialName, true), gettype($materialName)), __LINE__);
        }
        $this->MaterialName = $materialName;
        return $this;
    }
    /**
     * Get EPANumber value
     * @return string|null
     */
    public function getEPANumber()
    {
        return $this->EPANumber;
    }
    /**
     * Set EPANumber value
     * @param string $ePANumber
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setEPANumber($ePANumber = null)
    {
        // validation for constraint: string
        if (!is_null($ePANumber) && !is_string($ePANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePANumber, true), gettype($ePANumber)), __LINE__);
        }
        $this->EPANumber = $ePANumber;
        return $this;
    }
    /**
     * Get SDSFileName value
     * @return string|null
     */
    public function getSDSFileName()
    {
        return $this->SDSFileName;
    }
    /**
     * Set SDSFileName value
     * @param string $sDSFileName
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setSDSFileName($sDSFileName = null)
    {
        // validation for constraint: string
        if (!is_null($sDSFileName) && !is_string($sDSFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDSFileName, true), gettype($sDSFileName)), __LINE__);
        }
        $this->SDSFileName = $sDSFileName;
        return $this;
    }
    /**
     * Get SDSFileContent value
     * @return string|null
     */
    public function getSDSFileContent()
    {
        return $this->SDSFileContent;
    }
    /**
     * Set SDSFileContent value
     * @param string $sDSFileContent
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setSDSFileContent($sDSFileContent = null)
    {
        // validation for constraint: string
        if (!is_null($sDSFileContent) && !is_string($sDSFileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sDSFileContent, true), gettype($sDSFileContent)), __LINE__);
        }
        $this->SDSFileContent = $sDSFileContent;
        return $this;
    }
    /**
     * Get LabelFileName value
     * @return string|null
     */
    public function getLabelFileName()
    {
        return $this->LabelFileName;
    }
    /**
     * Set LabelFileName value
     * @param string $labelFileName
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setLabelFileName($labelFileName = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileName) && !is_string($labelFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFileName, true), gettype($labelFileName)), __LINE__);
        }
        $this->LabelFileName = $labelFileName;
        return $this;
    }
    /**
     * Get LabelFileContent value
     * @return string|null
     */
    public function getLabelFileContent()
    {
        return $this->LabelFileContent;
    }
    /**
     * Set LabelFileContent value
     * @param string $labelFileContent
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setLabelFileContent($labelFileContent = null)
    {
        // validation for constraint: string
        if (!is_null($labelFileContent) && !is_string($labelFileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFileContent, true), gettype($labelFileContent)), __LINE__);
        }
        $this->LabelFileContent = $labelFileContent;
        return $this;
    }
    /**
     * Get ChecksumSDS value
     * @return string|null
     */
    public function getChecksumSDS()
    {
        return $this->ChecksumSDS;
    }
    /**
     * Set ChecksumSDS value
     * @param string $checksumSDS
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setChecksumSDS($checksumSDS = null)
    {
        // validation for constraint: string
        if (!is_null($checksumSDS) && !is_string($checksumSDS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checksumSDS, true), gettype($checksumSDS)), __LINE__);
        }
        $this->ChecksumSDS = $checksumSDS;
        return $this;
    }
    /**
     * Get ChecksumLabel value
     * @return string|null
     */
    public function getChecksumLabel()
    {
        return $this->ChecksumLabel;
    }
    /**
     * Set ChecksumLabel value
     * @param string $checksumLabel
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setChecksumLabel($checksumLabel = null)
    {
        // validation for constraint: string
        if (!is_null($checksumLabel) && !is_string($checksumLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checksumLabel, true), gettype($checksumLabel)), __LINE__);
        }
        $this->ChecksumLabel = $checksumLabel;
        return $this;
    }
    /**
     * Get CALabelFileName value
     * @return string|null
     */
    public function getCALabelFileName()
    {
        return $this->CALabelFileName;
    }
    /**
     * Set CALabelFileName value
     * @param string $cALabelFileName
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setCALabelFileName($cALabelFileName = null)
    {
        // validation for constraint: string
        if (!is_null($cALabelFileName) && !is_string($cALabelFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cALabelFileName, true), gettype($cALabelFileName)), __LINE__);
        }
        $this->CALabelFileName = $cALabelFileName;
        return $this;
    }
    /**
     * Get CALabelFileContent value
     * @return string|null
     */
    public function getCALabelFileContent()
    {
        return $this->CALabelFileContent;
    }
    /**
     * Set CALabelFileContent value
     * @param string $cALabelFileContent
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setCALabelFileContent($cALabelFileContent = null)
    {
        // validation for constraint: string
        if (!is_null($cALabelFileContent) && !is_string($cALabelFileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cALabelFileContent, true), gettype($cALabelFileContent)), __LINE__);
        }
        $this->CALabelFileContent = $cALabelFileContent;
        return $this;
    }
    /**
     * Get ChecksumCALabel value
     * @return string|null
     */
    public function getChecksumCALabel()
    {
        return $this->ChecksumCALabel;
    }
    /**
     * Set ChecksumCALabel value
     * @param string $checksumCALabel
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setChecksumCALabel($checksumCALabel = null)
    {
        // validation for constraint: string
        if (!is_null($checksumCALabel) && !is_string($checksumCALabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checksumCALabel, true), gettype($checksumCALabel)), __LINE__);
        }
        $this->ChecksumCALabel = $checksumCALabel;
        return $this;
    }
    /**
     * Get Other value
     * @return string|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param string $other
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setOther($other = null)
    {
        // validation for constraint: string
        if (!is_null($other) && !is_string($other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($other, true), gettype($other)), __LINE__);
        }
        $this->Other = $other;
        return $this;
    }
    /**
     * Get OtherFileName value
     * @return string|null
     */
    public function getOtherFileName()
    {
        return $this->OtherFileName;
    }
    /**
     * Set OtherFileName value
     * @param string $otherFileName
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setOtherFileName($otherFileName = null)
    {
        // validation for constraint: string
        if (!is_null($otherFileName) && !is_string($otherFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFileName, true), gettype($otherFileName)), __LINE__);
        }
        $this->OtherFileName = $otherFileName;
        return $this;
    }
    /**
     * Get OtherFileContent value
     * @return string|null
     */
    public function getOtherFileContent()
    {
        return $this->OtherFileContent;
    }
    /**
     * Set OtherFileContent value
     * @param string $otherFileContent
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setOtherFileContent($otherFileContent = null)
    {
        // validation for constraint: string
        if (!is_null($otherFileContent) && !is_string($otherFileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherFileContent, true), gettype($otherFileContent)), __LINE__);
        }
        $this->OtherFileContent = $otherFileContent;
        return $this;
    }
    /**
     * Get ChecksumOther value
     * @return string|null
     */
    public function getChecksumOther()
    {
        return $this->ChecksumOther;
    }
    /**
     * Set ChecksumOther value
     * @param string $checksumOther
     * @return \LogBook\StructType\SDSandLabelFiles
     */
    public function setChecksumOther($checksumOther = null)
    {
        // validation for constraint: string
        if (!is_null($checksumOther) && !is_string($checksumOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checksumOther, true), gettype($checksumOther)), __LINE__);
        }
        $this->ChecksumOther = $checksumOther;
        return $this;
    }
}
