<?php

namespace LogBook\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAllCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LogBook\StructType\GetAllCategories $parameters
     * @return \LogBook\StructType\GetAllCategoriesResponse|bool
     */
    public function GetAllCategories(\LogBook\StructType\GetAllCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllSDSandLabelsDataAgainstSPragueID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LogBook\StructType\GetAllSDSandLabelsDataAgainstSPragueID $parameters
     * @return \LogBook\StructType\GetAllSDSandLabelsDataAgainstSPragueIDResponse|bool
     */
    public function GetAllSDSandLabelsDataAgainstSPragueID(\LogBook\StructType\GetAllSDSandLabelsDataAgainstSPragueID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllSDSandLabelsDataAgainstSPragueID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllActiveSDSandLabelsDataWithoutFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LogBook\StructType\GetAllActiveSDSandLabelsDataWithoutFiles $parameters
     * @return \LogBook\StructType\GetAllActiveSDSandLabelsDataWithoutFilesResponse|bool
     */
    public function GetAllActiveSDSandLabelsDataWithoutFiles(\LogBook\StructType\GetAllActiveSDSandLabelsDataWithoutFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllActiveSDSandLabelsDataWithoutFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllInactiveSpragueNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LogBook\StructType\GetAllInactiveSpragueNumber $parameters
     * @return \LogBook\StructType\GetAllInactiveSpragueNumberResponse|bool
     */
    public function GetAllInactiveSpragueNumber(\LogBook\StructType\GetAllInactiveSpragueNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllInactiveSpragueNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAllUpdatedSDSandLabelsDataWithoutFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LogBook\StructType\GetAllUpdatedSDSandLabelsDataWithoutFiles $parameters
     * @return \LogBook\StructType\GetAllUpdatedSDSandLabelsDataWithoutFilesResponse|bool
     */
    public function GetAllUpdatedSDSandLabelsDataWithoutFiles(\LogBook\StructType\GetAllUpdatedSDSandLabelsDataWithoutFiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAllUpdatedSDSandLabelsDataWithoutFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LogBook\StructType\GetAllActiveSDSandLabelsDataWithoutFilesResponse|\LogBook\StructType\GetAllCategoriesResponse|\LogBook\StructType\GetAllInactiveSpragueNumberResponse|\LogBook\StructType\GetAllSDSandLabelsDataAgainstSPragueIDResponse|\LogBook\StructType\GetAllUpdatedSDSandLabelsDataWithoutFilesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
