<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://lb.spraguepest.com/SDSandLabelService/WebServiceSDSandLabel.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://lb.spraguepest.com/SDSandLabelService/WebServiceSDSandLabel.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LogBook\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \LogBook\ServiceType\Get($options);
/**
 * Sample call for GetAllCategories operation/method
 */
if ($get->GetAllCategories(new \LogBook\StructType\GetAllCategories()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSDSandLabelsDataAgainstSPragueID operation/method
 */
if ($get->GetAllSDSandLabelsDataAgainstSPragueID(new \LogBook\StructType\GetAllSDSandLabelsDataAgainstSPragueID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllActiveSDSandLabelsDataWithoutFiles operation/method
 */
if ($get->GetAllActiveSDSandLabelsDataWithoutFiles(new \LogBook\StructType\GetAllActiveSDSandLabelsDataWithoutFiles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllInactiveSpragueNumber operation/method
 */
if ($get->GetAllInactiveSpragueNumber(new \LogBook\StructType\GetAllInactiveSpragueNumber()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllUpdatedSDSandLabelsDataWithoutFiles operation/method
 */
if ($get->GetAllUpdatedSDSandLabelsDataWithoutFiles(new \LogBook\StructType\GetAllUpdatedSDSandLabelsDataWithoutFiles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
