<?php

namespace LogBook\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Categories StructType
 * @subpackage Structs
 */
class Categories extends AbstractStructBase
{
    /**
     * The CategoryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CategoryDate;
    /**
     * The CategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryID;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * Constructor method for Categories
     * @uses Categories::setCategoryDate()
     * @uses Categories::setCategoryID()
     * @uses Categories::setCategoryName()
     * @param string $categoryDate
     * @param string $categoryID
     * @param string $categoryName
     */
    public function __construct($categoryDate = null, $categoryID = null, $categoryName = null)
    {
        $this
            ->setCategoryDate($categoryDate)
            ->setCategoryID($categoryID)
            ->setCategoryName($categoryName);
    }
    /**
     * Get CategoryDate value
     * @return string
     */
    public function getCategoryDate()
    {
        return $this->CategoryDate;
    }
    /**
     * Set CategoryDate value
     * @param string $categoryDate
     * @return \LogBook\StructType\Categories
     */
    public function setCategoryDate($categoryDate = null)
    {
        // validation for constraint: string
        if (!is_null($categoryDate) && !is_string($categoryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryDate, true), gettype($categoryDate)), __LINE__);
        }
        $this->CategoryDate = $categoryDate;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return string|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param string $categoryID
     * @return \LogBook\StructType\Categories
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: string
        if (!is_null($categoryID) && !is_string($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryID, true), gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \LogBook\StructType\Categories
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
}
