<?php

namespace LogBook;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'GetAllCategories' => '\\LogBook\\StructType\\GetAllCategories',
            'GetAllCategoriesResponse' => '\\LogBook\\StructType\\GetAllCategoriesResponse',
            'ArrayOfCategories' => '\\LogBook\\ArrayType\\ArrayOfCategories',
            'Categories' => '\\LogBook\\StructType\\Categories',
            'GetAllSDSandLabelsDataAgainstSPragueID' => '\\LogBook\\StructType\\GetAllSDSandLabelsDataAgainstSPragueID',
            'GetAllSDSandLabelsDataAgainstSPragueIDResponse' => '\\LogBook\\StructType\\GetAllSDSandLabelsDataAgainstSPragueIDResponse',
            'ArrayOfSDSandLabelFiles' => '\\LogBook\\ArrayType\\ArrayOfSDSandLabelFiles',
            'SDSandLabelFiles' => '\\LogBook\\StructType\\SDSandLabelFiles',
            'GetAllActiveSDSandLabelsDataWithoutFiles' => '\\LogBook\\StructType\\GetAllActiveSDSandLabelsDataWithoutFiles',
            'GetAllActiveSDSandLabelsDataWithoutFilesResponse' => '\\LogBook\\StructType\\GetAllActiveSDSandLabelsDataWithoutFilesResponse',
            'ArrayOfSDSandLabelWithoutFiles' => '\\LogBook\\ArrayType\\ArrayOfSDSandLabelWithoutFiles',
            'SDSandLabelWithoutFiles' => '\\LogBook\\StructType\\SDSandLabelWithoutFiles',
            'GetAllInactiveSpragueNumber' => '\\LogBook\\StructType\\GetAllInactiveSpragueNumber',
            'GetAllInactiveSpragueNumberResponse' => '\\LogBook\\StructType\\GetAllInactiveSpragueNumberResponse',
            'ArrayOfSpragueNumbers' => '\\LogBook\\ArrayType\\ArrayOfSpragueNumbers',
            'SpragueNumbers' => '\\LogBook\\StructType\\SpragueNumbers',
            'GetAllUpdatedSDSandLabelsDataWithoutFiles' => '\\LogBook\\StructType\\GetAllUpdatedSDSandLabelsDataWithoutFiles',
            'GetAllUpdatedSDSandLabelsDataWithoutFilesResponse' => '\\LogBook\\StructType\\GetAllUpdatedSDSandLabelsDataWithoutFilesResponse',
        );
    }
}
