<?php

namespace LogBook\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCategories ArrayType
 * @subpackage Arrays
 */
class ArrayOfCategories extends AbstractStructArrayBase
{
    /**
     * The Categories
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \LogBook\StructType\Categories[]
     */
    public $Categories;
    /**
     * Constructor method for ArrayOfCategories
     * @uses ArrayOfCategories::setCategories()
     * @param \LogBook\StructType\Categories[] $categories
     */
    public function __construct(array $categories = array())
    {
        $this
            ->setCategories($categories);
    }
    /**
     * Get Categories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \LogBook\StructType\Categories[]|null
     */
    public function getCategories()
    {
        return isset($this->Categories) ? $this->Categories : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCategories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoriesForArrayConstraintsFromSetCategories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCategoriesCategoriesItem) {
            // validation for constraint: itemType
            if (!$arrayOfCategoriesCategoriesItem instanceof \LogBook\StructType\Categories) {
                $invalidValues[] = is_object($arrayOfCategoriesCategoriesItem) ? get_class($arrayOfCategoriesCategoriesItem) : sprintf('%s(%s)', gettype($arrayOfCategoriesCategoriesItem), var_export($arrayOfCategoriesCategoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Categories property can only contain items of type \LogBook\StructType\Categories, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Categories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \LogBook\StructType\Categories[] $categories
     * @return \LogBook\ArrayType\ArrayOfCategories
     */
    public function setCategories(array $categories = array())
    {
        // validation for constraint: array
        if ('' !== ($categoriesArrayErrorMessage = self::validateCategoriesForArrayConstraintsFromSetCategories($categories))) {
            throw new \InvalidArgumentException($categoriesArrayErrorMessage, __LINE__);
        }
        if (is_null($categories) || (is_array($categories) && empty($categories))) {
            unset($this->Categories);
        } else {
            $this->Categories = $categories;
        }
        return $this;
    }
    /**
     * Add item to Categories value
     * @throws \InvalidArgumentException
     * @param \LogBook\StructType\Categories $item
     * @return \LogBook\ArrayType\ArrayOfCategories
     */
    public function addToCategories(\LogBook\StructType\Categories $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \LogBook\StructType\Categories) {
            throw new \InvalidArgumentException(sprintf('The Categories property can only contain items of type \LogBook\StructType\Categories, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Categories[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \LogBook\StructType\Categories|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \LogBook\StructType\Categories|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \LogBook\StructType\Categories|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \LogBook\StructType\Categories|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \LogBook\StructType\Categories|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Categories
     */
    public function getAttributeName()
    {
        return 'Categories';
    }
}
