<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimulationResultMT StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SimulationResultMT
 * @subpackage Structs
 */
class SimulationResultMT extends AbstractStructBase
{
    /**
     * The Error
     * @var bool
     */
    public $Error;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The FormalitesMedicales
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfArrayOfFormaliteMedicaleData
     */
    public $FormalitesMedicales;
    /**
     * The TableauCotisationsAssures
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfArrayOfCotisationRow
     */
    public $TableauCotisationsAssures;
    /**
     * The TableauCotisationsGlobal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfCotisationRow
     */
    public $TableauCotisationsGlobal;
    /**
     * The TableauTauxAssurePret
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfTauxAssurePret
     */
    public $TableauTauxAssurePret;
    /**
     * The TauxCommission
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfdouble
     */
    public $TauxCommission;
    /**
     * The TotalAssures
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfArrayOfCotisationData
     */
    public $TotalAssures;
    /**
     * The TotalGlobal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var ArrayOfCotisationData
     */
    public $TotalGlobal;
    /**
     * The TotalSouscriptionAssures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfMontantTotalSouscriptionData
     */
    public $TotalSouscriptionAssures;
    /**
     * Constructor method for SimulationResultMT
     * @uses SimulationResultMT::setError()
     * @uses SimulationResultMT::setErrorDescription()
     * @uses SimulationResultMT::setFormalitesMedicales()
     * @uses SimulationResultMT::setTableauCotisationsAssures()
     * @uses SimulationResultMT::setTableauCotisationsGlobal()
     * @uses SimulationResultMT::setTableauTauxAssurePret()
     * @uses SimulationResultMT::setTauxCommission()
     * @uses SimulationResultMT::setTotalAssures()
     * @uses SimulationResultMT::setTotalGlobal()
     * @uses SimulationResultMT::setTotalSouscriptionAssures()
     * @param bool $error
     * @param string $errorDescription
     * @param ArrayOfArrayOfFormaliteMedicaleData $formalitesMedicales
     * @param ArrayOfArrayOfCotisationRow $tableauCotisationsAssures
     * @param ArrayOfCotisationRow $tableauCotisationsGlobal
     * @param ArrayOfTauxAssurePret $tableauTauxAssurePret
     * @param ArrayOfdouble $tauxCommission
     * @param ArrayOfArrayOfCotisationData $totalAssures
     * @param ArrayOfCotisationData $totalGlobal
     * @param ArrayOfMontantTotalSouscriptionData $totalSouscriptionAssures
     */
    public function __construct($error = null, $errorDescription = null, ArrayOfArrayOfFormaliteMedicaleData $formalitesMedicales = null, ArrayOfArrayOfCotisationRow $tableauCotisationsAssures = null, ArrayOfCotisationRow $tableauCotisationsGlobal = null, ArrayOfTauxAssurePret $tableauTauxAssurePret = null, ArrayOfdouble $tauxCommission = null, ArrayOfArrayOfCotisationData $totalAssures = null, ArrayOfCotisationData $totalGlobal = null, ArrayOfMontantTotalSouscriptionData $totalSouscriptionAssures = null)
    {
        $this
            ->setError($error)
            ->setErrorDescription($errorDescription)
            ->setFormalitesMedicales($formalitesMedicales)
            ->setTableauCotisationsAssures($tableauCotisationsAssures)
            ->setTableauCotisationsGlobal($tableauCotisationsGlobal)
            ->setTableauTauxAssurePret($tableauTauxAssurePret)
            ->setTauxCommission($tauxCommission)
            ->setTotalAssures($totalAssures)
            ->setTotalGlobal($totalGlobal)
            ->setTotalSouscriptionAssures($totalSouscriptionAssures);
    }
    /**
     * Get Error value
     * @return bool|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param bool $error
     * @return SimulationResultMT
     */
    public function setError($error = null)
    {
        // validation for constraint: boolean
        if (!is_null($error) && !is_bool($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get ErrorDescription value
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->ErrorDescription;
    }
    /**
     * Set ErrorDescription value
     * @param string $errorDescription
     * @return SimulationResultMT
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        $this->ErrorDescription = $errorDescription;
        return $this;
    }
    /**
     * Get FormalitesMedicales value
     * @return ArrayOfArrayOfFormaliteMedicaleData|null
     */
    public function getFormalitesMedicales()
    {
        return $this->FormalitesMedicales;
    }
    /**
     * Set FormalitesMedicales value
     * @param ArrayOfArrayOfFormaliteMedicaleData $formalitesMedicales
     * @return SimulationResultMT
     */
    public function setFormalitesMedicales(ArrayOfArrayOfFormaliteMedicaleData $formalitesMedicales = null)
    {
        $this->FormalitesMedicales = $formalitesMedicales;
        return $this;
    }
    /**
     * Get TableauCotisationsAssures value
     * @return ArrayOfArrayOfCotisationRow|null
     */
    public function getTableauCotisationsAssures()
    {
        return $this->TableauCotisationsAssures;
    }
    /**
     * Set TableauCotisationsAssures value
     * @param ArrayOfArrayOfCotisationRow $tableauCotisationsAssures
     * @return SimulationResultMT
     */
    public function setTableauCotisationsAssures(ArrayOfArrayOfCotisationRow $tableauCotisationsAssures = null)
    {
        $this->TableauCotisationsAssures = $tableauCotisationsAssures;
        return $this;
    }
    /**
     * Get TableauCotisationsGlobal value
     * @return ArrayOfCotisationRow|null
     */
    public function getTableauCotisationsGlobal()
    {
        return $this->TableauCotisationsGlobal;
    }
    /**
     * Set TableauCotisationsGlobal value
     * @param ArrayOfCotisationRow $tableauCotisationsGlobal
     * @return SimulationResultMT
     */
    public function setTableauCotisationsGlobal(ArrayOfCotisationRow $tableauCotisationsGlobal = null)
    {
        $this->TableauCotisationsGlobal = $tableauCotisationsGlobal;
        return $this;
    }
    /**
     * Get TableauTauxAssurePret value
     * @return ArrayOfTauxAssurePret|null
     */
    public function getTableauTauxAssurePret()
    {
        return $this->TableauTauxAssurePret;
    }
    /**
     * Set TableauTauxAssurePret value
     * @param ArrayOfTauxAssurePret $tableauTauxAssurePret
     * @return SimulationResultMT
     */
    public function setTableauTauxAssurePret(ArrayOfTauxAssurePret $tableauTauxAssurePret = null)
    {
        $this->TableauTauxAssurePret = $tableauTauxAssurePret;
        return $this;
    }
    /**
     * Get TauxCommission value
     * @return ArrayOfdouble|null
     */
    public function getTauxCommission()
    {
        return $this->TauxCommission;
    }
    /**
     * Set TauxCommission value
     * @param ArrayOfdouble $tauxCommission
     * @return SimulationResultMT
     */
    public function setTauxCommission(ArrayOfdouble $tauxCommission = null)
    {
        $this->TauxCommission = $tauxCommission;
        return $this;
    }
    /**
     * Get TotalAssures value
     * @return ArrayOfArrayOfCotisationData|null
     */
    public function getTotalAssures()
    {
        return $this->TotalAssures;
    }
    /**
     * Set TotalAssures value
     * @param ArrayOfArrayOfCotisationData $totalAssures
     * @return SimulationResultMT
     */
    public function setTotalAssures(ArrayOfArrayOfCotisationData $totalAssures = null)
    {
        $this->TotalAssures = $totalAssures;
        return $this;
    }
    /**
     * Get TotalGlobal value
     * @return ArrayOfCotisationData|null
     */
    public function getTotalGlobal()
    {
        return $this->TotalGlobal;
    }
    /**
     * Set TotalGlobal value
     * @param ArrayOfCotisationData $totalGlobal
     * @return SimulationResultMT
     */
    public function setTotalGlobal(ArrayOfCotisationData $totalGlobal = null)
    {
        $this->TotalGlobal = $totalGlobal;
        return $this;
    }
    /**
     * Get TotalSouscriptionAssures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfMontantTotalSouscriptionData|null
     */
    public function getTotalSouscriptionAssures()
    {
        return isset($this->TotalSouscriptionAssures) ? $this->TotalSouscriptionAssures : null;
    }
    /**
     * Set TotalSouscriptionAssures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfMontantTotalSouscriptionData $totalSouscriptionAssures
     * @return SimulationResultMT
     */
    public function setTotalSouscriptionAssures(ArrayOfMontantTotalSouscriptionData $totalSouscriptionAssures = null)
    {
        if (is_null($totalSouscriptionAssures) || (is_array($totalSouscriptionAssures) && empty($totalSouscriptionAssures))) {
            unset($this->TotalSouscriptionAssures);
        } else {
            $this->TotalSouscriptionAssures = $totalSouscriptionAssures;
        }
        return $this;
    }
}
